<?php

if ( ! function_exists( 'urbango_edge_register_required_plugins' ) ) {
	/**
	 * Registers theme required and optional plugins. Hooks to tgmpa_register hook
	 */
	function urbango_edge_register_required_plugins() {
		$plugins = array(
			array(
				'name'               => esc_html__( 'WPBakery Visual Composer', 'urbango' ),
				'slug'               => 'js_composer',
				'source'             => get_template_directory() . '/includes/plugins/js_composer.zip',
				'version'            => '8.6.1',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__( 'Revolution Slider', 'urbango' ),
				'slug'               => 'revslider',
				'source'             => get_template_directory() . '/includes/plugins/revslider.zip',
				'version'            => '6.7.36',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__( 'UrbanGo Core', 'urbango' ),
				'slug'               => 'urbango-core',
				'source'             => get_template_directory() . '/includes/plugins/urbango-core.zip',
				'version'            => '1.5.2',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__( 'UrbanGo Listing', 'urbango' ),
				'slug'               => 'urbango-listing',
				'source'             => get_template_directory() . '/includes/plugins/urbango-listing.zip',
				'version'            => '1.3.1',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__( 'UrbanGo Checkout', 'urbango' ),
				'slug'               => 'urbango-checkout',
				'source'             => get_template_directory() . '/includes/plugins/urbango-checkout.zip',
				'version'            => '1.1',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'               => esc_html__( 'UrbanGo Membership', 'urbango' ),
				'slug'               => 'urbango-membership',
				'source'             => get_template_directory() . '/includes/plugins/urbango-membership.zip',
				'version'            => '1.1',
				'required'           => true,
				'force_activation'   => false,
				'force_deactivation' => false
			),
			array(
				'name'     => esc_html__( 'WooCommerce plugin', 'urbango' ),
				'slug'     => 'woocommerce',
				'required' => true
			),
			array(
				'name'     => esc_html__( 'Contact Form 7', 'urbango' ),
				'slug'     => 'contact-form-7',
				'required' => false
			),
			array(
				'name'     => esc_html__( 'Instagram Feed', 'urbango' ),
				'slug'     => 'instagram-feed',
				'required' => false,
			),
			array(
				'name'     => esc_html__( 'Custom Twitter Feeds', 'urbango' ),
				'slug'     => 'custom-twitter-feeds',
				'required' => false,
			),
			array(
				'name'     => esc_html__( 'Envato Market', 'urbango' ),
				'slug'     => 'envato-market',
				'source'   => 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
				'required' => false
			),
			array(
				'name'     => esc_html__( 'QODE Optimizer', 'urbango' ),
				'slug'     => 'qode-optimizer',
				'required' => false,
			),
		);

		$config = array(
			'domain'       => 'urbango',
			'default_path' => '',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'menu'         => 'install-required-plugins',
			'has_notices'  => true,
			'is_automatic' => false,
			'message'      => '',
			'strings'      => array(
				'page_title'                      => esc_html__( 'Install Required Plugins', 'urbango' ),
				'menu_title'                      => esc_html__( 'Install Plugins', 'urbango' ),
				'installing'                      => esc_html__( 'Installing Plugin: %s', 'urbango' ),
				'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'urbango' ),
				'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'urbango' ),
				'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'urbango' ),
				'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'urbango' ),
				'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'urbango' ),
				'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'urbango' ),
				'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'urbango' ),
				'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'urbango' ),
				'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'urbango' ),
				'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'urbango' ),
				'activate_link'                   => _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'urbango' ),
				'return'                          => esc_html__( 'Return to Required Plugins Installer', 'urbango' ),
				'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'urbango' ),
				'complete'                        => esc_html__( 'All plugins installed and activated successfully. %s', 'urbango' ),
				'nag_type'                        => 'updated'
			)
		);

		tgmpa( $plugins, $config );
	}

	add_action( 'tgmpa_register', 'urbango_edge_register_required_plugins' );
}