<?php

if ( ! function_exists( 'urbango_edge_map_woocommerce_meta' ) ) {
	function urbango_edge_map_woocommerce_meta() {
		
		$woocommerce_meta_box = urbango_edge_create_meta_box(
			array(
				'scope' => array( 'product' ),
				'title' => esc_html__( 'Product Meta', 'urbango' ),
				'name'  => 'woo_product_meta'
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_product_featured_image_size',
				'type'        => 'select',
				'label'       => esc_html__( 'Dimensions for Product List Shortcode', 'urbango' ),
				'description' => esc_html__( 'Choose image layout when it appears in Edge Product List - Masonry layout shortcode', 'urbango' ),
				'options'     => array(
					''                   => esc_html__( 'Default', 'urbango' ),
					'small'              => esc_html__( 'Small', 'urbango' ),
					'large-width'        => esc_html__( 'Large Width', 'urbango' ),
					'large-height'       => esc_html__( 'Large Height', 'urbango' ),
					'large-width-height' => esc_html__( 'Large Width Height', 'urbango' )
				),
				'parent'      => $woocommerce_meta_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_show_title_area_woo_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'urbango' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'urbango' ),
				'options'       => urbango_edge_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_show_new_sign_woo_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show New Sign', 'urbango' ),
				'description'   => esc_html__( 'Enabling this option will show new sign mark on product', 'urbango' ),
				'parent'        => $woocommerce_meta_box
			)
		);
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_edge_map_woocommerce_meta', 99 );
}