<?php

class UrbanGoEdgeClassSeparatorWidget extends UrbanGoEdgeClassWidget {
	public function __construct() {
		parent::__construct(
			'edgtf_separator_widget',
			esc_html__( 'UrbanGo Separator Widget', 'urbango' ),
			array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'urbango' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Type', 'urbango' ),
				'options' => array(
					'normal'     => esc_html__( 'Normal', 'urbango' ),
					'full-width' => esc_html__( 'Full Width', 'urbango' )
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'position',
				'title'   => esc_html__( 'Position', 'urbango' ),
				'options' => array(
					'center' => esc_html__( 'Center', 'urbango' ),
					'left'   => esc_html__( 'Left', 'urbango' ),
					'right'  => esc_html__( 'Right', 'urbango' )
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'border_style',
				'title'   => esc_html__( 'Style', 'urbango' ),
				'options' => array(
					'solid'  => esc_html__( 'Solid', 'urbango' ),
					'dashed' => esc_html__( 'Dashed', 'urbango' ),
					'dotted' => esc_html__( 'Dotted', 'urbango' )
				)
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'urbango' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'width',
				'title' => esc_html__( 'Width (px or %)', 'urbango' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'thickness',
				'title' => esc_html__( 'Thickness (px)', 'urbango' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'top_margin',
				'title' => esc_html__( 'Top Margin (px or %)', 'urbango' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'bottom_margin',
				'title' => esc_html__( 'Bottom Margin (px or %)', 'urbango' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}
		
		//prepare variables
		$params = '';
		
		//is instance empty?
		if ( is_array( $instance ) && count( $instance ) ) {
			//generate shortcode params
			foreach ( $instance as $key => $value ) {
				$params .= " $key='$value' ";
			}
		}
		
		echo '<div class="widget edgtf-separator-widget">';
			echo do_shortcode( "[edgtf_separator $params]" ); // XSS OK
		echo '</div>';
	}
}