<?php

class UrbanGoEdgeClassSearchPostType extends UrbanGoEdgeClassWidget {
	public function __construct() {
		parent::__construct(
			'edgtf_search_post_type',
			esc_html__( 'UrbanGo Search Post Type', 'urbango' ),
			array( 'description' => esc_html__( 'Select post type that you want to be searched for', 'urbango' ) )
		);

		$this->setParams();
	}

	protected function setParams() {
		$post_types = apply_filters( 'urbango_edge_filter_search_post_type_widget_params_post_type', array( 'post' => esc_html__( 'Post', 'urbango' ) ) );

		$this->params = array(
			array(
				'type'        => 'dropdown',
				'name'        => 'post_type',
				'title'       => esc_html__( 'Post Type', 'urbango' ),
				'description' => esc_html__( 'Choose post type that you want to be searched for', 'urbango' ),
				'options'     => $post_types
			)
		);
	}

	public function widget( $args, $instance ) {
		$post_type = $instance['post_type'];
		?>
        <div class="widget edgtf-search-post-type-widget">
            <form role="search" method="get" class="edgtf-search-post-type" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                <label class="screen-reader-text"><?php esc_html_e( 'Search for:', 'urbango' ); ?></label>
                <div class="edgtf-search-post-type-inner">
                    <div class="edgtf-post-type-search-field">
                        <input type="search" placeholder="<?php esc_attr_e( 'What are you looking for?', 'urbango' ); ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php esc_attr_e( 'Search for:', 'urbango' ); ?>" required/>
						<?php wp_nonce_field( 'edgtf_search_post_types_nonce', 'edgtf_search_post_types_nonce' ); ?>
                    </div>
                    <div class="edgtf-post-type-search-submit">
                        <button type="submit">
							<?php echo urbango_edge_icon_collections()->renderIcon( 'fas fa-search', 'font_awesome' ); ?>
                            <span class="edgtf-post-type-search-label"><?php esc_attr_e( 'Search', 'urbango' ) ?></span>
                        </button>
                    </div>
                    <input type="hidden" name="post_type" value="<?php echo esc_attr( $post_type ); ?>"/>
					<?php if ( $post_type === 'listing-item' ) { ?>
                        <input type="hidden" name="edgtf-listing-search" value="yes"/>
					<?php } ?>
                </div>
            </form>
        </div>
	<?php }
}