<?php

class UrbanGoEdgeClassButtonWidget extends UrbanGoEdgeClassWidget {
	public function __construct() {
		parent::__construct(
			'edgtf_button_widget',
			esc_html__( 'UrbanGo Button Widget', 'urbango' ),
			array( 'description' => esc_html__( 'Add button element to widget areas', 'urbango' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Type', 'urbango' ),
				'options' => array(
					'solid'   => esc_html__( 'Solid', 'urbango' ),
					'outline' => esc_html__( 'Outline', 'urbango' ),
					'simple'  => esc_html__( 'Simple', 'urbango' )
				)
			),
			array(
				'type'        => 'dropdown',
				'name'        => 'size',
				'title'       => esc_html__( 'Size', 'urbango' ),
				'options'     => array(
					'small'  => esc_html__( 'Small', 'urbango' ),
					'medium' => esc_html__( 'Medium', 'urbango' ),
					'large'  => esc_html__( 'Large', 'urbango' ),
					'huge'   => esc_html__( 'Huge', 'urbango' )
				),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'urbango' )
			),
			array(
				'type'    => 'textfield',
				'name'    => 'text',
				'title'   => esc_html__( 'Text', 'urbango' ),
				'default' => esc_html__( 'Button Text', 'urbango' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'link',
				'title' => esc_html__( 'Link', 'urbango' )
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'target',
				'title'   => esc_html__( 'Link Target', 'urbango' ),
				'options' => urbango_edge_get_link_target_array()
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'urbango' )
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'hover_color',
				'title' => esc_html__( 'Hover Color', 'urbango' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'background_color',
				'title'       => esc_html__( 'Background Color', 'urbango' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'urbango' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'hover_background_color',
				'title'       => esc_html__( 'Hover Background Color', 'urbango' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'urbango' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'border_color',
				'title'       => esc_html__( 'Border Color', 'urbango' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'urbango' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'hover_border_color',
				'title'       => esc_html__( 'Hover Border Color', 'urbango' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'urbango' )
			),
			array(
				'type'        => 'textfield',
				'name'        => 'margin',
				'title'       => esc_html__( 'Margin', 'urbango' ),
				'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'urbango' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		$params = '';
		
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}
		
		// Filter out all empty params
		$instance = array_filter( $instance, function ( $array_value ) {
			return trim( $array_value ) != '';
		} );
		
		// Default values
		if ( ! isset( $instance['text'] ) ) {
			$instance['text'] = 'Button Text';
		}
		
		// Generate shortcode params
		foreach ( $instance as $key => $value ) {
			$params .= " $key='$value' ";
		}
		
		echo '<div class="widget edgtf-button-widget">';
			echo do_shortcode( "[edgtf_button $params]" ); // XSS OK
		echo '</div>';
	}
}