<?php

class UrbanGoEdgeClassAuthorInfoWidget extends UrbanGoEdgeClassWidget {
	public function __construct() {
		parent::__construct(
			'edgtf_author_info_widget',
			esc_html__( 'UrbanGo Author Info Widget', 'urbango' ),
			array( 'description' => esc_html__( 'Add author info element to widget areas', 'urbango' ) )
		);

		$this->setParams();
	}

	protected function setParams() {
		$this->params = array(
			array(
				'type'  => 'textfield',
				'name'  => 'extra_class',
				'title' => esc_html__( 'Custom CSS Class', 'urbango' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'widget_bottom_margin',
				'title' => esc_html__( 'Widget Bottom Margin (px)', 'urbango' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'author_username',
				'title' => esc_html__( 'Author Username', 'urbango' )
			)
		);
	}

	public function widget( $args, $instance ) {
		extract( $args );

		$extra_class = '';
		if ( ! empty( $instance['extra_class'] ) ) {
			$extra_class = $instance['extra_class'];
		}

		$widget_styles = array();
		if ( isset( $instance['widget_bottom_margin'] ) && $instance['widget_bottom_margin'] !== '' ) {
			$widget_styles[] = 'margin-bottom: ' . urbango_edge_filter_px( $instance['widget_bottom_margin'] ) . 'px';
		}

		$authorID = 1;
		if ( ! empty( $instance['author_username'] ) ) {
			$author = get_user_by( 'login', $instance['author_username'] );

			if ( $author ) {
				$authorID = $author->ID;
			}
		}

		$author_info     = get_the_author_meta( 'description', $authorID );
		$social_networks = urbango_edge_core_plugin_installed() ? urbango_edge_get_user_custom_fields() : false;
		?>

        <div class="edgtf-author-info-widget <?php echo esc_attr( $extra_class ); ?>" <?php echo urbango_edge_get_inline_style( $widget_styles ); ?>>
            <a itemprop="url" class="edgtf-aiw-image" href="<?php echo esc_url( get_author_posts_url( $authorID ) ); ?>">
				<?php echo urbango_edge_kses_img( get_avatar( $authorID, 288 ) ); ?>
                <span class="edgtf-aiw-name vcard author">
					<span class="fn">
						<?php if ( get_the_author_meta( 'first_name' ) != "" || get_the_author_meta( 'last_name' ) != "" ) {
							echo esc_html( get_the_author_meta( 'first_name' ) ) . " " . esc_html( get_the_author_meta( 'last_name' ) );
						} else {
							echo esc_html( get_the_author_meta( 'display_name' ) );
						} ?>
					</span>
				</span>
            </a>
            <div class="edgtf-aiw-content">
				<?php if ( $author_info !== "" ) { ?>
                    <h5 class="edgtf-aiw-title"><?php esc_html_e( 'About', 'urbango' ); ?></h5>
                    <p itemprop="description" class="edgtf-aiw-text"><?php echo wp_kses_post( $author_info ); ?></p>
					<?php if ( ! empty( $social_networks ) ) { ?>
                        <div class="edgtf-aiw-social-icons clearfix">
							<?php foreach ( $social_networks as $network ) { ?>
                                <a itemprop="url" href="<?php echo esc_url( $network['link'] ) ?>" target="_blank">
									<?php echo urbango_edge_icon_collections()->renderIcon( $network['class'], 'font_elegant' ); ?>
                                </a>
							<?php } ?>
                        </div>
					<?php } ?>
				<?php } ?>
            </div>
        </div>
		<?php
	}
}