<?php

/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
if ( function_exists( 'vc_set_as_theme' ) ) {
	vc_set_as_theme( true );
}

/**
 * Change path for overridden templates
 */
if ( function_exists( 'vc_set_shortcodes_templates_dir' ) ) {
	$dir = EDGE_ROOT_DIR . '/vc-templates';
	vc_set_shortcodes_templates_dir( $dir );
}

if ( ! function_exists( 'urbango_edge_configure_visual_composer_frontend_editor' ) ) {
	/**
	 * Configuration for Visual Composer FrontEnd Editor
	 * Hooks on vc_after_init action
	 */
	function urbango_edge_configure_visual_composer_frontend_editor() {
		/**
		 * Remove frontend editor
		 */
		if ( function_exists( 'vc_disable_frontend' ) ) {
			vc_disable_frontend();
		}
	}
	
	add_action( 'vc_after_init', 'urbango_edge_configure_visual_composer_frontend_editor' );
}

if ( ! function_exists( 'urbango_edge_vc_row_map' ) ) {
	/**
	 * Map VC Row shortcode
	 * Hooks on vc_after_init action
	 */
	function urbango_edge_vc_row_map() {
		
		/******* VC Row shortcode - begin *******/
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Edge Row Content Width', 'urbango' ),
				'value'      => array(
					esc_html__( 'Full Width', 'urbango' ) => 'full-width',
					esc_html__( 'In Grid', 'urbango' )    => 'grid'
				),
				'group'      => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'anchor',
				'heading'     => esc_html__( 'Edge Anchor ID', 'urbango' ),
				'description' => esc_html__( 'For example "home"', 'urbango' ),
				'group'       => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Edge Background Color', 'urbango' ),
				'group'      => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Edge Background Image', 'urbango' ),
				'group'      => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'background_image_position',
				'heading'     => esc_html__( 'Edge Background Position', 'urbango' ),
				'description' => esc_html__( 'Set the starting position of a background image, default value is top left', 'urbango' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Edge Disable Background Image', 'urbango' ),
				'value'       => array(
					esc_html__( 'Never', 'urbango' )        => '',
					esc_html__( 'Below 1280px', 'urbango' ) => '1280',
					esc_html__( 'Below 1024px', 'urbango' ) => '1024',
					esc_html__( 'Below 768px', 'urbango' )  => '768',
					esc_html__( 'Below 680px', 'urbango' )  => '680',
					esc_html__( 'Below 480px', 'urbango' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'urbango' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'parallax_background_image',
				'heading'    => esc_html__( 'Edge Parallax Background Image', 'urbango' ),
				'group'      => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'parallax_bg_speed',
				'heading'     => esc_html__( 'Edge Parallax Speed', 'urbango' ),
				'description' => esc_html__( 'Set your parallax speed. Default value is 1.', 'urbango' ),
				'dependency'  => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'textfield',
				'param_name' => 'parallax_bg_height',
				'heading'    => esc_html__( 'Edge Parallax Section Height (px)', 'urbango' ),
				'dependency' => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'      => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Edge Content Aligment', 'urbango' ),
				'value'      => array(
					esc_html__( 'Default', 'urbango' ) => '',
					esc_html__( 'Left', 'urbango' )    => 'left',
					esc_html__( 'Center', 'urbango' )  => 'center',
					esc_html__( 'Right', 'urbango' )   => 'right'
				),
				'group'      => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		/******* VC Row shortcode - end *******/
		
		/******* VC Row Inner shortcode - begin *******/
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Edge Row Content Width', 'urbango' ),
				'value'      => array(
					esc_html__( 'Full Width', 'urbango' ) => 'full-width',
					esc_html__( 'In Grid', 'urbango' )    => 'grid'
				),
				'group'      => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Edge Background Color', 'urbango' ),
				'group'      => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Edge Background Image', 'urbango' ),
				'group'      => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'textfield',
				'param_name'  => 'background_image_position',
				'heading'     => esc_html__( 'Edge Background Position', 'urbango' ),
				'description' => esc_html__( 'Set the starting position of a background image, default value is top left', 'urbango' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Edge Disable Background Image', 'urbango' ),
				'value'       => array(
					esc_html__( 'Never', 'urbango' )        => '',
					esc_html__( 'Below 1280px', 'urbango' ) => '1280',
					esc_html__( 'Below 1024px', 'urbango' ) => '1024',
					esc_html__( 'Below 768px', 'urbango' )  => '768',
					esc_html__( 'Below 680px', 'urbango' )  => '680',
					esc_html__( 'Below 480px', 'urbango' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'urbango' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Edge Content Aligment', 'urbango' ),
				'value'      => array(
					esc_html__( 'Default', 'urbango' ) => '',
					esc_html__( 'Left', 'urbango' )    => 'left',
					esc_html__( 'Center', 'urbango' )  => 'center',
					esc_html__( 'Right', 'urbango' )   => 'right'
				),
				'group'      => esc_html__( 'Edge Settings', 'urbango' )
			)
		);
		
		/******* VC Row Inner shortcode - end *******/
		
		/******* VC Revolution Slider shortcode - begin *******/
		
		if ( urbango_edge_revolution_slider_installed() ) {
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'enable_paspartu',
					'heading'     => esc_html__( 'Edge Enable Passepartout', 'urbango' ),
					'value'       => array_flip( urbango_edge_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'group'       => esc_html__( 'Edge Settings', 'urbango' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'paspartu_size',
					'heading'     => esc_html__( 'Edge Passepartout Size', 'urbango' ),
					'value'       => array(
						esc_html__( 'Tiny', 'urbango' )   => 'tiny',
						esc_html__( 'Small', 'urbango' )  => 'small',
						esc_html__( 'Normal', 'urbango' ) => 'normal',
						esc_html__( 'Large', 'urbango' )  => 'large'
					),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Edge Settings', 'urbango' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_side_paspartu',
					'heading'     => esc_html__( 'Edge Disable Side Passepartout', 'urbango' ),
					'value'       => array_flip( urbango_edge_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Edge Settings', 'urbango' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_top_paspartu',
					'heading'     => esc_html__( 'Edge Disable Top Passepartout', 'urbango' ),
					'value'       => array_flip( urbango_edge_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Edge Settings', 'urbango' )
				)
			);
		}
		
		/******* VC Revolution Slider shortcode - end *******/
	}
	
	add_action( 'vc_after_init', 'urbango_edge_vc_row_map' );
}