<?php

if ( ! function_exists( 'urbango_edge_get_title_types_meta_boxes' ) ) {
	function urbango_edge_get_title_types_meta_boxes() {
		$title_type_options = apply_filters( 'urbango_edge_filter_title_type_meta_boxes', $title_type_options = array( '' => esc_html__( 'Default', 'urbango' ) ) );
		
		return $title_type_options;
	}
}

foreach ( glob( EDGE_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'urbango_edge_map_title_meta' ) ) {
	function urbango_edge_map_title_meta() {
		$title_type_meta_boxes = urbango_edge_get_title_types_meta_boxes();
		
		$title_meta_box = urbango_edge_create_meta_box(
			array(
				'scope' => apply_filters( 'urbango_edge_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'title_meta' ),
				'title' => esc_html__( 'Title', 'urbango' ),
				'name'  => 'title_meta'
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_show_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'urbango' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'urbango' ),
				'parent'        => $title_meta_box,
				'options'       => urbango_edge_get_yes_no_select_array()
			)
		);
		
			$show_title_area_meta_container = urbango_edge_add_admin_container(
				array(
					'parent'          => $title_meta_box,
					'name'            => 'edgtf_show_title_area_meta_container',
					'dependency' => array(
						'hide' => array(
							'edgtf_show_title_area_meta' => 'no'
						)
					)
				)
			);
		
				urbango_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_type_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area Type', 'urbango' ),
						'description'   => esc_html__( 'Choose title type', 'urbango' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => $title_type_meta_boxes
					)
				);
		
				urbango_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_in_grid_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area In Grid', 'urbango' ),
						'description'   => esc_html__( 'Set title area content to be in grid', 'urbango' ),
						'options'       => urbango_edge_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container
					)
				);
		
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_title_area_height_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height', 'urbango' ),
						'description' => esc_html__( 'Set a height for Title Area', 'urbango' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_title_area_background_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Background Color', 'urbango' ),
						'description' => esc_html__( 'Choose a background color for title area', 'urbango' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_title_area_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'urbango' ),
						'description' => esc_html__( 'Choose an Image for title area', 'urbango' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				urbango_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_background_image_behavior_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Behavior', 'urbango' ),
						'description'   => esc_html__( 'Choose title area background image behavior', 'urbango' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''                    => esc_html__( 'Default', 'urbango' ),
							'hide'                => esc_html__( 'Hide Image', 'urbango' ),
							'responsive'          => esc_html__( 'Enable Responsive Image', 'urbango' ),
							'responsive-disabled' => esc_html__( 'Disable Responsive Image', 'urbango' ),
							'parallax'            => esc_html__( 'Enable Parallax Image', 'urbango' ),
							'parallax-zoom-out'   => esc_html__( 'Enable Parallax With Zoom Out Image', 'urbango' ),
							'parallax-disabled'   => esc_html__( 'Disable Parallax Image', 'urbango' )
						)
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Vertical Alignment', 'urbango' ),
						'description'   => esc_html__( 'Specify title area content vertical alignment', 'urbango' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''              => esc_html__( 'Default', 'urbango' ),
							'header-bottom' => esc_html__( 'From Bottom of Header', 'urbango' ),
							'window-top'    => esc_html__( 'From Window Top', 'urbango' )
						)
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_title_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Tag', 'urbango' ),
						'options'       => urbango_edge_get_title_tag( true ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_title_text_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Color', 'urbango' ),
						'description' => esc_html__( 'Choose a color for title text', 'urbango' ),
						'parent'      => $show_title_area_meta_container
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_subtitle_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Text', 'urbango' ),
						'description'   => esc_html__( 'Enter your subtitle text', 'urbango' ),
						'parent'        => $show_title_area_meta_container,
						'args'          => array(
							'col_width' => 6
						)
					)
				);
		
				urbango_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_title_area_subtitle_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Tag', 'urbango' ),
						'options'       => urbango_edge_get_title_tag( true, array( 'p' => 'p', 'span' => esc_html__( 'Custom Heading', 'urbango' ) ) ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_subtitle_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Subtitle Color', 'urbango' ),
						'description' => esc_html__( 'Choose a color for subtitle text', 'urbango' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'urbango_edge_action_additional_title_area_meta_boxes', $show_title_area_meta_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_edge_map_title_meta', 60 );
}