<?php

if ( ! function_exists( 'urbango_edge_register_sidebars' ) ) {
	/**
	 * Function that registers theme's sidebars
	 */
	function urbango_edge_register_sidebars() {
		
		register_sidebar(
			array(
				'id'            => 'sidebar',
				'name'          => esc_html__( 'Sidebar', 'urbango' ),
				'description'   => esc_html__( 'Default Sidebar area. In order to display this area you need to enable it through global theme options or on page meta box options.', 'urbango' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h5 class="edgtf-widget-title">',
				'after_title'   => '</h5>'
			)
		);
	}
	
	add_action( 'widgets_init', 'urbango_edge_register_sidebars', 1 );
}

if ( ! function_exists( 'urbango_edge_add_support_custom_sidebar' ) ) {
	/**
	 * Function that adds theme support for custom sidebars. It also creates UrbanGoEdgeClassSidebar object
	 */
	function urbango_edge_add_support_custom_sidebar() {
		add_theme_support( 'UrbanGoEdgeClassSidebar' );
		
		if ( get_theme_support( 'UrbanGoEdgeClassSidebar' ) ) {
			new UrbanGoEdgeClassSidebar();
		}
	}
	
	add_action( 'after_setup_theme', 'urbango_edge_add_support_custom_sidebar' );
}