<?php

if ( ! function_exists( 'urbango_edge_sidebar_options_map' ) ) {
	function urbango_edge_sidebar_options_map() {
		
		urbango_edge_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'urbango' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = urbango_edge_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'urbango' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		urbango_edge_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'urbango' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'urbango' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => urbango_edge_get_custom_sidebars_options()
		) );
		
		$urbango_custom_sidebars = urbango_edge_get_custom_sidebars();
		if ( is_array( $urbango_custom_sidebars ) && count( $urbango_custom_sidebars ) > 0 ) {
			urbango_edge_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'urbango' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'urbango' ),
				'parent'      => $sidebar_panel,
				'options'     => $urbango_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'urbango_edge_action_options_map', 'urbango_edge_sidebar_options_map', urbango_edge_set_options_map_position( 'sidebar' ) );
}