<?php

if ( ! function_exists( 'urbango_edge_map_sidebar_meta' ) ) {
	function urbango_edge_map_sidebar_meta() {
		$edgtf_sidebar_meta_box = urbango_edge_create_meta_box(
			array(
				'scope' => apply_filters( 'urbango_edge_filter_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'urbango' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'urbango' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'urbango' ),
				'parent'      => $edgtf_sidebar_meta_box,
                'options'       => urbango_edge_get_custom_sidebars_options( true )
			)
		);
		
		$edgtf_custom_sidebars = urbango_edge_get_custom_sidebars();
		if ( is_array( $edgtf_custom_sidebars ) && count( $edgtf_custom_sidebars ) > 0 ) {
			urbango_edge_create_meta_box_field(
				array(
					'name'        => 'edgtf_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'urbango' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'urbango' ),
					'parent'      => $edgtf_sidebar_meta_box,
					'options'     => $edgtf_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_edge_map_sidebar_meta', 31 );
}