(function($) {
    "use strict";

    var sidearea = {};
    edgtf.modules.sidearea = sidearea;

    sidearea.edgtfOnDocumentReady = edgtfOnDocumentReady;

    $(document).ready(edgtfOnDocumentReady);
    
    /* 
        All functions to be called on $(document).ready() should be in this function
    */
    function edgtfOnDocumentReady() {
	    edgtfSideArea();
    }
	
	/**
	 * Show/hide side area
	 */
    function edgtfSideArea() {
		var wrapper = $('.edgtf-wrapper'),
			sideMenu = $('.edgtf-side-menu'),
			sideMenuButtonOpen = $('a.edgtf-side-menu-button-opener'),
			cssClass,
			//Flags
			slideFromRight = false,
			slideWithContent = false,
			slideUncovered = false;
		
		if (edgtf.body.hasClass('edgtf-side-menu-slide-from-right')) {
			$('.edgtf-cover').remove();
			cssClass = 'edgtf-right-side-menu-opened';
			wrapper.prepend('<div class="edgtf-cover"/>');
			slideFromRight = true;
		} else if (edgtf.body.hasClass('edgtf-side-menu-slide-with-content')) {
			cssClass = 'edgtf-side-menu-open';
			slideWithContent = true;
		} else if (edgtf.body.hasClass('edgtf-side-area-uncovered-from-content')) {
			cssClass = 'edgtf-right-side-menu-opened';
			slideUncovered = true;
		}
		
		$('a.edgtf-side-menu-button-opener, a.edgtf-close-side-menu').on('click', function (e) {
			e.preventDefault();
	
	        if (!sideMenuButtonOpen.hasClass('opened')) {
		        sideMenuButtonOpen.addClass('opened');
		        edgtf.body.addClass(cssClass);
		
		        if (slideFromRight) {
			        $('.edgtf-wrapper .edgtf-cover').on('click', function () {
				        edgtf.body.removeClass('edgtf-right-side-menu-opened');
				        sideMenuButtonOpen.removeClass('opened');
			        });
		        }
		
		        if (slideUncovered) {
			        sideMenu.css({
				        'visibility': 'visible'
			        });
		        }
		
		        var currentScroll = $(window).scrollTop();
		        $(window).scroll(function () {
			        if (Math.abs(edgtf.scroll - currentScroll) > 400) {
				        edgtf.body.removeClass(cssClass);
				        sideMenuButtonOpen.removeClass('opened');
				        if (slideUncovered) {
					        var hideSideMenu = setTimeout(function () {
						        sideMenu.css({'visibility': 'hidden'});
						        clearTimeout(hideSideMenu);
					        }, 400);
				        }
			        }
		        });
            } else {
	            sideMenuButtonOpen.removeClass('opened');
	            edgtf.body.removeClass(cssClass);
	
	            if (slideUncovered) {
		            var hideSideMenu = setTimeout(function () {
			            sideMenu.css({'visibility': 'hidden'});
			            clearTimeout(hideSideMenu);
		            }, 400);
	            }
            }
	
	        if (slideWithContent) {
		        e.stopPropagation();
		
		        wrapper.on('click', function () {
			        e.preventDefault();
			        sideMenuButtonOpen.removeClass('opened');
			        edgtf.body.removeClass('edgtf-side-menu-open');
		        });
	        }
        });

        if(sideMenu.length){
            edgtf.modules.common.edgtfInitPerfectScrollbar().init(sideMenu);
        }
    }

})(jQuery);
