<?php

if ( ! function_exists( 'urbango_edge_sidearea_options_map' ) ) {
	function urbango_edge_sidearea_options_map() {

        urbango_edge_add_admin_page(
            array(
                'slug'  => '_side_area_page',
                'title' => esc_html__('Side Area', 'urbango'),
                'icon'  => 'fa fa-indent'
            )
        );

        $side_area_panel = urbango_edge_add_admin_panel(
            array(
                'title' => esc_html__('Side Area', 'urbango'),
                'name'  => 'side_area',
                'page'  => '_side_area_page'
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_type',
                'default_value' => 'side-menu-slide-from-right',
                'label'         => esc_html__('Side Area Type', 'urbango'),
                'description'   => esc_html__('Choose a type of Side Area', 'urbango'),
                'options'       => array(
                    'side-menu-slide-from-right'       => esc_html__('Slide from Right Over Content', 'urbango'),
                    'side-menu-slide-with-content'     => esc_html__('Slide from Right With Content', 'urbango'),
                    'side-area-uncovered-from-content' => esc_html__('Side Area Uncovered from Content', 'urbango'),
                ),
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'text',
                'name'          => 'side_area_width',
                'default_value' => '',
                'label'         => esc_html__('Side Area Width', 'urbango'),
                'description'   => esc_html__('Enter a width for Side Area (px or %). Default width: 405px.', 'urbango'),
                'args'          => array(
                    'col_width' => 3,
                )
            )
        );

        $side_area_width_container = urbango_edge_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_width_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_type' => 'side-menu-slide-from-right',
                    )
                )
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'color',
                'name'          => 'side_area_content_overlay_color',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Color', 'urbango'),
                'description'   => esc_html__('Choose a background color for a content overlay', 'urbango'),
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'text',
                'name'          => 'side_area_content_overlay_opacity',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Transparency', 'urbango'),
                'description'   => esc_html__('Choose a transparency for the content overlay background color (0 = fully transparent, 1 = opaque)', 'urbango'),
                'args'          => array(
                    'col_width' => 3
                )
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_icon_source',
                'default_value' => 'icon_pack',
                'label'         => esc_html__('Select Side Area Icon Source', 'urbango'),
                'description'   => esc_html__('Choose whether you would like to use icons from an icon pack or SVG icons', 'urbango'),
                'options'       => urbango_edge_get_icon_sources_array()
            )
        );

        $side_area_icon_pack_container = urbango_edge_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_icon_pack_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'icon_pack'
                    )
                )
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $side_area_icon_pack_container,
                'type'          => 'select',
                'name'          => 'side_area_icon_pack',
                'default_value' => 'font_awesome',
                'label'         => esc_html__('Side Area Icon Pack', 'urbango'),
                'description'   => esc_html__('Choose icon pack for Side Area icon', 'urbango'),
                'options'       => urbango_edge_icon_collections()->getIconCollectionsExclude(array('linea_icons', 'dripicons', 'simple_line_icons'))
            )
        );

        $side_area_svg_icons_container = urbango_edge_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_svg_icons_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'svg_path'
                    )
                )
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_icon_svg_path',
                'label'       => esc_html__('Side Area Icon SVG Path', 'urbango'),
                'description' => esc_html__('Enter your Side Area icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'urbango'),
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_close_icon_svg_path',
                'label'       => esc_html__('Side Area Close Icon SVG Path', 'urbango'),
                'description' => esc_html__('Enter your Side Area close icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'urbango'),
            )
        );

        $side_area_icon_style_group = urbango_edge_add_admin_group(
            array(
                'parent'      => $side_area_panel,
                'name'        => 'side_area_icon_style_group',
                'title'       => esc_html__('Side Area Icon Style', 'urbango'),
                'description' => esc_html__('Define styles for Side Area icon', 'urbango')
            )
        );

        $side_area_icon_style_row1 = urbango_edge_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row1'
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_color',
                'label'  => esc_html__('Color', 'urbango')
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_hover_color',
                'label'  => esc_html__('Hover Color', 'urbango')
            )
        );

        $side_area_icon_style_row2 = urbango_edge_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row2',
                'next'   => true
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_color',
                'label'  => esc_html__('Close Icon Color', 'urbango')
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_hover_color',
                'label'  => esc_html__('Close Icon Hover Color', 'urbango')
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'color',
                'name'        => 'side_area_background_color',
                'label'       => esc_html__('Background Color', 'urbango'),
                'description' => esc_html__('Choose a background color for Side Area', 'urbango')
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'text',
                'name'        => 'side_area_padding',
                'label'       => esc_html__('Padding', 'urbango'),
                'description' => esc_html__('Define padding for Side Area in format top right bottom left', 'urbango'),
                'args'        => array(
                    'col_width' => 3
                )
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'selectblank',
                'name'          => 'side_area_aligment',
                'default_value' => '',
                'label'         => esc_html__('Text Alignment', 'urbango'),
                'description'   => esc_html__('Choose text alignment for side area', 'urbango'),
                'options'       => array(
                    ''       => esc_html__('Default', 'urbango'),
                    'left'   => esc_html__('Left', 'urbango'),
                    'center' => esc_html__('Center', 'urbango'),
                    'right'  => esc_html__('Right', 'urbango')
                )
            )
        );
    }

    add_action('urbango_edge_action_options_map', 'urbango_edge_sidearea_options_map', urbango_edge_set_options_map_position( 'sidearea' ) );
}