(function($) {
    "use strict";

    var searchSlideFromHB = {};
    edgtf.modules.searchSlideFromHB = searchSlideFromHB;

    searchSlideFromHB.edgtfOnDocumentReady = edgtfOnDocumentReady;

    $(document).ready(edgtfOnDocumentReady);
    
    /* 
        All functions to be called on $(document).ready() should be in this function
    */
    function edgtfOnDocumentReady() {
	    edgtfSearchSlideFromHB();
    }
	
	/**
	 * Init Search Types
	 */
	function edgtfSearchSlideFromHB() {
        if ( edgtf.body.hasClass( 'edgtf-slide-from-header-bottom' ) ) {
            var searchOpener = $('a.edgtf-search-opener');

            if (searchOpener.length) {
	            searchOpener.each(function(){
		            //Check for type of search
		            $(this).on('click', function (e) {
			            e.preventDefault();
			
			            var thisSearchOpener = $(this),
				            searchIconPosition = parseInt(edgtf.windowWidth - thisSearchOpener.offset().left - thisSearchOpener.outerWidth());
			
			            if (edgtf.body.hasClass('edgtf-boxed') && edgtf.windowWidth > 1024) {
				            searchIconPosition -= parseInt((edgtf.windowWidth - $('.edgtf-boxed .edgtf-wrapper .edgtf-wrapper-inner').outerWidth()) / 2);
			            }
			
			            var searchFormHeaderHolder = $('.edgtf-page-header'),
				            searchFormTopOffset = '100%',
				            searchFormTopHeaderHolder = $('.edgtf-top-bar'),
				            searchFormFixedHeaderHolder = searchFormHeaderHolder.find('.edgtf-fixed-wrapper.fixed'),
				            searchFormMobileHeaderHolder = $('.edgtf-mobile-header'),
				            searchForm = searchFormHeaderHolder.children('.edgtf-slide-from-header-bottom-holder'),
				            searchFormIsInTopHeader = !!thisSearchOpener.parents('.edgtf-top-bar').length,
				            searchFormIsInFixedHeader = !!thisSearchOpener.parents('.edgtf-fixed-wrapper.fixed').length,
				            searchFormIsInStickyHeader = !!thisSearchOpener.parents('.edgtf-sticky-header').length,
				            searchFormIsInMobileHeader = !!thisSearchOpener.parents('.edgtf-mobile-header').length;
			
			            searchForm.removeClass('edgtf-is-active');
			
			            //Find search form position in header and height
			            if (searchFormIsInTopHeader) {
				            searchForm = searchFormTopHeaderHolder.find('.edgtf-slide-from-header-bottom-holder');
				            searchForm.addClass('edgtf-is-active');
				
			            } else if (searchFormIsInFixedHeader) {
				            searchFormTopOffset = searchFormFixedHeaderHolder.outerHeight() + edgtfGlobalVars.vars.edgtfAddForAdminBar;
				            searchForm.addClass('edgtf-is-active');
				
			            } else if (searchFormIsInStickyHeader) {
				            searchFormTopOffset = edgtfGlobalVars.vars.edgtfStickyHeaderHeight + edgtfGlobalVars.vars.edgtfAddForAdminBar - 1;
				            searchForm.addClass('edgtf-is-active');
				
			            } else if (searchFormIsInMobileHeader) {
				            if (searchFormMobileHeaderHolder.hasClass('mobile-header-appear')) {
					            searchFormTopOffset = searchFormMobileHeaderHolder.children('.edgtf-mobile-header-inner').outerHeight() + edgtfGlobalVars.vars.edgtfAddForAdminBar;
				            }
				
				            searchForm = searchFormMobileHeaderHolder.find('.edgtf-slide-from-header-bottom-holder');
				            searchForm.addClass('edgtf-is-active');
				
			            } else {
				            searchForm.addClass('edgtf-is-active');
			            }
			           
			            if (searchForm.hasClass('edgtf-is-active')) {
				            searchForm.css({
					            'right': searchIconPosition,
					            'top': searchFormTopOffset
							}).stop(true).fadeToggle(300, 'easeOutQuint');
			            }
			
			            //Close on escape
			            $(document).keyup(function (e) {
				            if (e.keyCode === 27) { //KeyCode for ESC button is 27
					            searchForm.stop(true).fadeOut(0);
				            }
			            });
			
			            $(window).scroll(function () {
				            searchForm.stop(true).fadeOut(0);
			            });
		            });
	            });
            }
        }
	}

})(jQuery);
