<?php

if ( ! function_exists( 'urbango_edge_set_header_top_enabled_class' ) ) {
    function urbango_edge_set_header_top_enabled_class( $classes ) {

        if ( urbango_edge_is_top_bar_enabled() ) {
            $classes[] = 'edgtf-header-top-enabled';
        }

        return $classes;
    }

    add_filter( 'body_class', 'urbango_edge_set_header_top_enabled_class' );
}

if ( ! function_exists( 'urbango_edge_top_header_global_js_var' ) ) {
	function urbango_edge_top_header_global_js_var( $global_variables ) {
		$global_variables['edgtfTopBarHeight'] = urbango_edge_get_top_bar_height();
		
		return $global_variables;
	}
	
	add_filter( 'urbango_edge_filter_js_global_variables', 'urbango_edge_top_header_global_js_var' );
}

if ( ! function_exists( 'urbango_edge_get_header_top' ) ) {
	/**
	 * Loads header top HTML and sets parameters for it
	 */
	function urbango_edge_get_header_top() {
		$skin_meta      = get_post_meta( urbango_edge_get_page_id(), 'edgtf_top_bar_skin_meta', true );
		$holder_classes = ! empty( $skin_meta ) ? 'edgtf-' . $skin_meta : '';
		
		$params = array(
			'show_header_top'                => urbango_edge_is_top_bar_enabled(),
			'show_header_top_background_div' => urbango_edge_get_meta_field_intersect( 'header_type' ) == 'header-box',
			'top_bar_in_grid'                => urbango_edge_get_meta_field_intersect( 'top_bar_in_grid' ) == 'yes',
			'holder_classes'                 => $holder_classes
		);
		
		$params = apply_filters( 'urbango_edge_filter_header_top_params', $params );
		
		urbango_edge_get_module_template_part( 'templates/top-header', 'header/types/top-header', '', $params );
	}
	
	add_action( 'urbango_edge_action_before_page_header', 'urbango_edge_get_header_top' );
}

if ( ! function_exists( 'urbango_edge_is_top_bar_enabled' ) ) {
	/**
	 * Returns is top header area enabled
	 *
	 * @return bool
	 */
	function urbango_edge_is_top_bar_enabled() {
		$top_bar_enabled = urbango_edge_get_meta_field_intersect( 'top_bar' ) === 'yes' ? true : false;
		
		if ( is_404() ) {
			$top_bar_enabled = false;
		}
		
		return apply_filters( 'urbango_edge_filter_enabled_top_bar', $top_bar_enabled );
	}
}

if ( ! function_exists( 'urbango_edge_get_top_bar_height' ) ) {
	/**
	 * Returns top header area height
	 *
	 * @return bool|int|void
	 */
	function urbango_edge_get_top_bar_height() {
		if ( urbango_edge_is_top_bar_enabled() ) {
			$top_bar_height_meta = urbango_edge_filter_px( urbango_edge_options()->getOptionValue( 'top_bar_height' ) );
			$top_bar_height      = ! empty( $top_bar_height_meta ) ? $top_bar_height_meta : 47;
			
			return $top_bar_height;
		} else {
			return 0;
		}
	}
}

if ( ! function_exists( 'urbango_edge_get_top_bar_background_height' ) ) {
	/**
	 * Returns top header area background height
	 *
	 * @return bool|int|void
	 */
	function urbango_edge_get_top_bar_background_height() {
		$top_bar_height_meta = urbango_edge_filter_px( urbango_edge_options()->getOptionValue( 'top_bar_height' ) );
		$header_height_meta  = urbango_edge_filter_px( urbango_edge_options()->getOptionValue( 'menu_area_height' ) );
		
		$top_bar_height = ! empty( $top_bar_height_meta ) ? $top_bar_height_meta : urbango_edge_get_top_bar_height();
		$header_height  = ! empty( $header_height_meta ) ? $header_height_meta : urbango_edge_set_default_logo_height_for_header_types();
		
		$top_bar_background_height = round( $top_bar_height ) + round( $header_height / 2 );
		
		return $top_bar_background_height;
	}
}

if ( ! function_exists( 'urbango_edge_is_top_bar_transparent' ) ) {
	/**
	 * Checks if top header area is transparent or not
	 *
	 * @return bool
	 */
	function urbango_edge_is_top_bar_transparent() {
		$top_bar_enabled      = urbango_edge_is_top_bar_enabled();
		$top_bar_bg_color     = urbango_edge_options()->getOptionValue( 'top_bar_background_color' );
		$top_bar_transparency = urbango_edge_options()->getOptionValue( 'top_bar_background_transparency' );
		
		if ( $top_bar_enabled && $top_bar_bg_color !== '' && $top_bar_transparency !== '' ) {
			return $top_bar_transparency >= 0 && $top_bar_transparency < 1;
		} else {
			return false;
		}
	}
}

if ( ! function_exists( 'urbango_edge_is_top_bar_completely_transparent' ) ) {
	/**
	 * Checks is top header area completely transparent
	 *
	 * @return bool
	 */
	function urbango_edge_is_top_bar_completely_transparent() {
		$top_bar_enabled      = urbango_edge_is_top_bar_enabled();
		$top_bar_bg_color     = urbango_edge_options()->getOptionValue( 'top_bar_background_color' );
		$top_bar_transparency = urbango_edge_options()->getOptionValue( 'top_bar_background_transparency' );
		
		if ( $top_bar_enabled && $top_bar_bg_color !== '' && $top_bar_transparency !== '' ) {
			return $top_bar_transparency === '0';
		} else {
			return false;
		}
	}
}

if ( ! function_exists( 'urbango_edge_register_top_header_areas' ) ) {
	/**
	 * Registers widget areas for top header bar when it is enabled
	 */
	function urbango_edge_register_top_header_areas() {
		register_sidebar(
			array(
				'id'            => 'edgtf-top-bar-left',
				'name'          => esc_html__( 'Header Top Bar Left Column', 'urbango' ),
				'description'   => esc_html__( 'Widgets added here will appear on the left side in top bar header', 'urbango' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s edgtf-top-bar-widget">',
				'after_widget'  => '</div>'
			)
		);
		
		register_sidebar(
			array(
				'id'            => 'edgtf-top-bar-right',
				'name'          => esc_html__( 'Header Top Bar Right Column', 'urbango' ),
				'description'   => esc_html__( 'Widgets added here will appear on the right side in top bar header', 'urbango' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s edgtf-top-bar-widget">',
				'after_widget'  => '</div>'
			)
		);
	}
	
	add_action( 'widgets_init', 'urbango_edge_register_top_header_areas' );
}

if ( ! function_exists( 'urbango_edge_top_bar_grid_class' ) ) {
	/**
	 * @param $classes
	 *
	 * @return array
	 */
	function urbango_edge_top_bar_grid_class( $classes ) {
		if ( urbango_edge_get_meta_field_intersect( 'top_bar_in_grid', urbango_edge_get_page_id() ) == 'yes' &&
		     urbango_edge_options()->getOptionValue( 'top_bar_grid_background_color' ) !== '' &&
		     urbango_edge_options()->getOptionValue( 'top_bar_grid_background_transparency' ) !== '0'
		) {
			$classes[] = 'edgtf-top-bar-in-grid-padding';
		}
		
		return $classes;
	}
	
	add_filter( 'body_class', 'urbango_edge_top_bar_grid_class' );
}

if ( ! function_exists( 'urbango_edge_get_top_bar_styles' ) ) {
	/**
	 * Sets per page styles for header top bar
	 *
	 * @param $styles
	 *
	 * @return array
	 */
	function urbango_edge_get_top_bar_styles( $styles ) {
		$page_id      = urbango_edge_get_page_id();
		$class_prefix = urbango_edge_get_unique_page_class( $page_id, true );
		
		$top_bar_style = array();
		
		$top_bar_bg_color     = get_post_meta( $page_id, 'edgtf_top_bar_background_color_meta', true );
		$top_bar_border       = get_post_meta( $page_id, 'edgtf_top_bar_border_meta', true );
		$top_bar_border_color = get_post_meta( $page_id, 'edgtf_top_bar_border_color_meta', true );
		
		$current_style = '';
		
		$top_bar_selector = array(
			$class_prefix . ' .edgtf-top-bar'
		);
		
		if ( $top_bar_bg_color !== '' ) {
			$top_bar_transparency = get_post_meta( $page_id, 'edgtf_top_bar_background_transparency_meta', true );
			if ( $top_bar_transparency === '' ) {
				$top_bar_transparency = 1;
			}
			$top_bar_style['background-color'] = urbango_edge_rgba_color( $top_bar_bg_color, $top_bar_transparency );
		}
		
		if ( $top_bar_border == 'yes' ) {
			$top_bar_style['border-bottom'] = '1px solid ' . $top_bar_border_color;
		} elseif ( $top_bar_border == 'no' ) {
			$top_bar_style['border-bottom'] = '0';
		}
		
		$current_style .= urbango_edge_dynamic_css( $top_bar_selector, $top_bar_style );
		
		$current_style = $current_style . $styles;
		
		return $current_style;
	}
	
	add_filter( 'urbango_edge_filter_add_page_custom_style', 'urbango_edge_get_top_bar_styles' );
}