<?php

if ( ! function_exists( 'urbango_edge_get_hide_dep_for_top_header_area_meta_boxes' ) ) {
	function urbango_edge_get_hide_dep_for_top_header_area_meta_boxes() {
		$hide_dep_options = apply_filters( 'urbango_edge_filter_top_header_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'urbango_edge_header_top_area_meta_options_map' ) ) {
	function urbango_edge_header_top_area_meta_options_map( $header_meta_box ) {
		$hide_dep_options = urbango_edge_get_hide_dep_for_top_header_area_meta_boxes();
		
		$top_header_container = urbango_edge_add_admin_container_no_style(
			array(
				'type'            => 'container',
				'name'            => 'top_header_container',
				'parent'          => $header_meta_box,
				'dependency' => array(
					'hide' => array(
						'edgtf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'parent' => $top_header_container,
				'name'   => 'top_area_style',
				'title'  => esc_html__( 'Top Area', 'urbango' )
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_top_bar_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Header Top Bar', 'urbango' ),
				'description'   => esc_html__( 'Enabling this option will show header top bar area', 'urbango' ),
				'parent'        => $top_header_container,
				'options'       => urbango_edge_get_yes_no_select_array(),
			)
		);
		
		$top_bar_container = urbango_edge_add_admin_container_no_style(
			array(
				'name'            => 'top_bar_container_no_style',
				'parent'          => $top_header_container,
				'dependency' => array(
					'show' => array(
						'edgtf_top_bar_meta' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_top_bar_in_grid_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Top Bar In Grid', 'urbango' ),
				'description'   => esc_html__( 'Set top bar content to be in grid', 'urbango' ),
				'parent'        => $top_bar_container,
				'default_value' => '',
				'options'       => urbango_edge_get_yes_no_select_array()
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_top_bar_background_color_meta',
				'type'   => 'color',
				'label'  => esc_html__( 'Top Bar Background Color', 'urbango' ),
				'parent' => $top_bar_container
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_top_bar_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Top Bar Background Color Transparency', 'urbango' ),
				'description' => esc_html__( 'Set top bar background color transparenct. Value should be between 0 and 1', 'urbango' ),
				'parent'      => $top_bar_container,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_top_bar_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Top Bar Border', 'urbango' ),
				'description'   => esc_html__( 'Set border on top bar', 'urbango' ),
				'parent'        => $top_bar_container,
				'default_value' => '',
				'options'       => urbango_edge_get_yes_no_select_array()
			)
		);
		
		$top_bar_border_container = urbango_edge_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'top_bar_border_container',
				'parent'          => $top_bar_container,
				'dependency' => array(
					'show' => array(
						'edgtf_top_bar_border_meta' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_top_bar_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'urbango' ),
				'description' => esc_html__( 'Choose color for top bar border', 'urbango' ),
				'parent'      => $top_bar_border_container
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_top_bar_skin_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Top Bar Skin', 'urbango' ),
				'description'   => esc_html__( 'Set top bar header area skin for area and for items', 'urbango' ),
				'options'       => array(
					''      => esc_html__( 'Default', 'urbango' ),
					'light' => esc_html__( 'Light', 'urbango' )
				),
				'parent'        => $top_bar_container
			)
		);
	}
	
	add_action( 'urbango_edge_action_additional_header_area_meta_boxes_map', 'urbango_edge_header_top_area_meta_options_map', 10, 1 );
}