<?php

if ( ! function_exists( 'urbango_edge_get_hide_dep_for_header_standard_options' ) ) {
	function urbango_edge_get_hide_dep_for_header_standard_options() {
		$hide_dep_options = apply_filters( 'urbango_edge_filter_header_standard_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'urbango_edge_header_standard_map' ) ) {
	function urbango_edge_header_standard_map( $parent ) {
		$hide_dep_options = urbango_edge_get_hide_dep_for_header_standard_options();
		
		urbango_edge_add_admin_field(
			array(
				'name'        => 'logo_area_top_padding_standard_header',
				'type'        => 'text',
				'label'       => esc_html__( 'Logo Area Top Padding', 'urbango' ),
				'description' => esc_html__( 'Define logo area top padding for standard header type', 'urbango' ),
				'parent'      => $parent,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'set_menu_area_position',
				'default_value'   => 'right',
				'label'           => esc_html__( 'Choose Menu Area Position', 'urbango' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'urbango' ),
				'options'         => array(
					'right'  => esc_html__( 'Right', 'urbango' ),
					'left'   => esc_html__( 'Left', 'urbango' ),
					'center' => esc_html__( 'Center', 'urbango' )
				),
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'urbango_edge_action_additional_header_menu_area_options_map', 'urbango_edge_header_standard_map' );
}