<?php

if ( ! function_exists( 'urbango_edge_get_hide_dep_for_header_standard_meta_boxes' ) ) {
	function urbango_edge_get_hide_dep_for_header_standard_meta_boxes() {
		$hide_dep_options = apply_filters( 'urbango_edge_filter_header_standard_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'urbango_edge_header_standard_meta_map' ) ) {
	function urbango_edge_header_standard_meta_map( $parent ) {
		$hide_dep_options = urbango_edge_get_hide_dep_for_header_standard_meta_boxes();
		
		urbango_edge_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'edgtf_set_menu_area_position_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Menu Area Position', 'urbango' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'urbango' ),
				'options'         => array(
					''       => esc_html__( 'Default', 'urbango' ),
					'left'   => esc_html__( 'Left', 'urbango' ),
					'right'  => esc_html__( 'Right', 'urbango' ),
					'center' => esc_html__( 'Center', 'urbango' )
				),
				'dependency' => array(
					'hide' => array(
						'edgtf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'urbango_edge_action_additional_header_area_meta_boxes_map', 'urbango_edge_header_standard_meta_map' );
}