<?php

if ( ! function_exists( 'urbango_edge_get_hide_dep_for_header_menu_area_options' ) ) {
	function urbango_edge_get_hide_dep_for_header_menu_area_options() {
		$hide_dep_options = apply_filters( 'urbango_edge_filter_header_menu_area_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'urbango_edge_header_menu_area_options_map' ) ) {
	function urbango_edge_header_menu_area_options_map( $panel_header ) {
		$hide_dep_options = urbango_edge_get_hide_dep_for_header_menu_area_options();
		
		$menu_area_container = urbango_edge_add_admin_container_no_style(
			array(
				'parent'          => $panel_header,
				'name'            => 'menu_area_container',
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				),
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'parent' => $menu_area_container,
				'name'   => 'menu_area_style',
				'title'  => esc_html__( 'Menu Area Style', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_in_grid',
				'default_value' => 'no',
				'label'         => esc_html__( 'Menu Area In Grid', 'urbango' ),
				'description'   => esc_html__( 'Set menu area content to be in grid', 'urbango' ),
			)
		);
		
		$menu_area_in_grid_container = urbango_edge_add_admin_container(
			array(
				'parent'          => $menu_area_container,
				'name'            => 'menu_area_in_grid_container',
				'dependency' => array(
					'hide' => array(
						'menu_area_in_grid'  => 'no'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'color',
				'name'          => 'menu_area_grid_background_color',
				'default_value' => '',
				'label'         => esc_html__( 'Grid Background Color', 'urbango' ),
				'description'   => esc_html__( 'Set grid background color for menu area', 'urbango' ),
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'text',
				'name'          => 'menu_area_grid_background_transparency',
				'default_value' => '',
				'label'         => esc_html__( 'Grid Background Transparency', 'urbango' ),
				'description'   => esc_html__( 'Set grid background transparency for menu area', 'urbango' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_in_grid_shadow',
				'default_value' => 'no',
				'label'         => esc_html__( 'Grid Area Shadow', 'urbango' ),
				'description'   => esc_html__( 'Set shadow on grid area', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_in_grid_border',
				'default_value' => 'no',
				'label'         => esc_html__( 'Grid Area Border', 'urbango' ),
				'description'   => esc_html__( 'Set border on grid area', 'urbango' )
			)
		);
		
		$menu_area_in_grid_border_container = urbango_edge_add_admin_container(
			array(
				'parent'          => $menu_area_in_grid_container,
				'name'            => 'menu_area_in_grid_border_container',
				'dependency' => array(
					'hide' => array(
						'menu_area_in_grid_border'  => 'no'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_border_container,
				'type'          => 'color',
				'name'          => 'menu_area_in_grid_border_color',
				'default_value' => '',
				'label'         => esc_html__( 'Border Color', 'urbango' ),
				'description'   => esc_html__( 'Set border color for menu area', 'urbango' ),
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'color',
				'name'          => 'menu_area_background_color',
				'default_value' => '',
				'label'         => esc_html__( 'Background Color', 'urbango' ),
				'description'   => esc_html__( 'Set background color for menu area', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'text',
				'name'          => 'menu_area_background_transparency',
				'default_value' => '',
				'label'         => esc_html__( 'Background Transparency', 'urbango' ),
				'description'   => esc_html__( 'Set background transparency for menu area', 'urbango' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_shadow',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Menu Area Shadow', 'urbango' ),
				'description'   => esc_html__( 'Set shadow on menu area', 'urbango' ),
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'menu_area_border',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Menu Area Border', 'urbango' ),
				'description'   => esc_html__( 'Set border on menu area', 'urbango' ),
				'parent'        => $menu_area_container
			)
		);
		
		$menu_area_border_container = urbango_edge_add_admin_container(
			array(
				'parent'          => $menu_area_container,
				'name'            => 'menu_area_border_container',
				'dependency' => array(
					'hide' => array(
						'menu_area_border'  => 'no'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'type'        => 'color',
				'name'        => 'menu_area_border_color',
				'label'       => esc_html__( 'Border Color', 'urbango' ),
				'description' => esc_html__( 'Set border color for menu area', 'urbango' ),
				'parent'      => $menu_area_border_container
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'type'        => 'text',
				'name'        => 'menu_area_height',
				'label'       => esc_html__( 'Height', 'urbango' ),
				'description' => esc_html__( 'Enter header height', 'urbango' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'type'   => 'text',
				'name'   => 'menu_area_side_padding',
				'label'  => esc_html__( 'Menu Area Side Padding', 'urbango' ),
				'parent' => $menu_area_container,
				'args'   => array(
					'col_width' => 2,
					'suffix'    => esc_html__( 'px or %', 'urbango' )
				)
			)
		);
		
		do_action( 'urbango_edge_header_menu_area_additional_options', $panel_header );
	}
	
	add_action( 'urbango_edge_action_header_menu_area_options_map', 'urbango_edge_header_menu_area_options_map', 10, 1 );
}