<?php

if ( ! function_exists( 'urbango_edge_logo_options_map' ) ) {
	function urbango_edge_logo_options_map() {
		
		urbango_edge_add_admin_page(
			array(
				'slug'  => '_logo_page',
				'title' => esc_html__( 'Logo', 'urbango' ),
				'icon'  => 'fa fa-coffee'
			)
		);
		
		$panel_logo = urbango_edge_add_admin_panel(
			array(
				'page'  => '_logo_page',
				'name'  => 'panel_logo',
				'title' => esc_html__( 'Logo', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $panel_logo,
				'type'          => 'yesno',
				'name'          => 'hide_logo',
				'default_value' => 'no',
				'label'         => esc_html__( 'Hide Logo', 'urbango' ),
				'description'   => esc_html__( 'Enabling this option will hide logo image', 'urbango' )
			)
		);
		
		$hide_logo_container = urbango_edge_add_admin_container(
			array(
				'parent'          => $panel_logo,
				'name'            => 'hide_logo_container',
				'dependency' => array(
					'hide' => array(
						'hide_logo'  => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'logo_image',
				'type'          => 'image',
				'default_value' => EDGE_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Default', 'urbango' ),
				'parent'        => $hide_logo_container
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'logo_image_dark',
				'type'          => 'image',
				'default_value' => EDGE_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Dark', 'urbango' ),
				'parent'        => $hide_logo_container
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'logo_image_light',
				'type'          => 'image',
				'default_value' => EDGE_ASSETS_ROOT . "/img/logo_white.png",
				'label'         => esc_html__( 'Logo Image - Light', 'urbango' ),
				'parent'        => $hide_logo_container
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'logo_image_sticky',
				'type'          => 'image',
				'default_value' => EDGE_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Sticky', 'urbango' ),
				'parent'        => $hide_logo_container
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'logo_image_mobile',
				'type'          => 'image',
				'default_value' => EDGE_ASSETS_ROOT . "/img/logo.png",
				'label'         => esc_html__( 'Logo Image - Mobile', 'urbango' ),
				'parent'        => $hide_logo_container
			)
		);
	}
	
	add_action( 'urbango_edge_action_options_map', 'urbango_edge_logo_options_map', urbango_edge_set_options_map_position( 'logo' ) );
}