<?php

if ( ! function_exists( 'urbango_edge_footer_options_map' ) ) {
	function urbango_edge_footer_options_map() {

		urbango_edge_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'urbango' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = urbango_edge_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'urbango' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);

		urbango_edge_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'urbango' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'urbango' ),
				'parent'        => $footer_panel
			)
		);

        urbango_edge_add_admin_field(
            array(
                'type'          => 'yesno',
                'name'          => 'uncovering_footer',
                'default_value' => 'no',
                'label'         => esc_html__( 'Uncovering Footer', 'urbango' ),
                'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'urbango' ),
                'parent'        => $footer_panel,
            )
        );

		urbango_edge_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'urbango' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'urbango' ),
				'parent'        => $footer_panel,
			)
		);
		
		$show_footer_top_container = urbango_edge_add_admin_container(
			array(
				'name'       => 'show_footer_top_container',
				'parent'     => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_top' => 'yes'
					)
				)
			)
		);

		urbango_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '3 3 3 3',
				'label'         => esc_html__( 'Footer Top Columns', 'urbango' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'urbango' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
                    '3 3 6' => '3 (25% + 25% + 50%)',
					'3 3 3 3' => '4'
				)
			)
		);

		urbango_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'left',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'urbango' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'urbango' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'urbango' ),
					'left'   => esc_html__( 'Left', 'urbango' ),
					'center' => esc_html__( 'Center', 'urbango' ),
					'right'  => esc_html__( 'Right', 'urbango' )
				),
				'parent'        => $show_footer_top_container,
			)
		);
		
		$footer_top_styles_group = urbango_edge_add_admin_group(
			array(
				'name'        => 'footer_top_styles_group',
				'title'       => esc_html__( 'Footer Top Styles', 'urbango' ),
				'description' => esc_html__( 'Define style for footer top area', 'urbango' ),
				'parent'      => $show_footer_top_container
			)
		);
		
		$footer_top_styles_row_1 = urbango_edge_add_admin_row(
			array(
				'name'   => 'footer_top_styles_row_1',
				'parent' => $footer_top_styles_group
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'   => 'footer_top_background_color',
				'type'   => 'colorsimple',
				'label'  => esc_html__( 'Background Color', 'urbango' ),
				'parent' => $footer_top_styles_row_1
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'   => 'footer_top_border_color',
				'type'   => 'colorsimple',
				'label'  => esc_html__( 'Border Color', 'urbango' ),
				'parent' => $footer_top_styles_row_1
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'   => 'footer_top_border_width',
				'type'   => 'textsimple',
				'label'  => esc_html__( 'Border Width', 'urbango' ),
				'parent' => $footer_top_styles_row_1,
				'args'   => array(
					'suffix' => 'px'
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'urbango' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'urbango' ),
				'parent'        => $footer_panel
			)
		);
		
		$show_footer_bottom_container = urbango_edge_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'parent'          => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_bottom'  => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '6 6',
				'label'         => esc_html__( 'Footer Bottom Columns', 'urbango' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'urbango' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3'
				),
				'parent'        => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_group = urbango_edge_add_admin_group(
			array(
				'name'        => 'footer_bottom_styles_group',
				'title'       => esc_html__( 'Footer Bottom Styles', 'urbango' ),
				'description' => esc_html__( 'Define style for footer bottom area', 'urbango' ),
				'parent'      => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_row_1 = urbango_edge_add_admin_row(
			array(
				'name'   => 'footer_bottom_styles_row_1',
				'parent' => $footer_bottom_styles_group
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'   => 'footer_bottom_background_color',
				'type'   => 'colorsimple',
				'label'  => esc_html__( 'Background Color', 'urbango' ),
				'parent' => $footer_bottom_styles_row_1
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'   => 'footer_bottom_border_color',
				'type'   => 'colorsimple',
				'label'  => esc_html__( 'Border Color', 'urbango' ),
				'parent' => $footer_bottom_styles_row_1
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'   => 'footer_bottom_border_width',
				'type'   => 'textsimple',
				'label'  => esc_html__( 'Border Width', 'urbango' ),
				'parent' => $footer_bottom_styles_row_1,
				'args'   => array(
					'suffix' => 'px'
				)
			)
		);
	}

	add_action( 'urbango_edge_action_options_map', 'urbango_edge_footer_options_map', urbango_edge_set_options_map_position( 'footer' ) );
}