<?php

if ( ! function_exists( 'urbango_edge_footer_top_general_styles' ) ) {
	/**
	 * Generates general custom styles for footer top area
	 */
	function urbango_edge_footer_top_general_styles() {
		$item_styles       = array();
		$item_inner_styles = array();
		$background_color  = urbango_edge_options()->getOptionValue( 'footer_top_background_color' );
		$border_color      = urbango_edge_options()->getOptionValue( 'footer_top_border_color' );
		$border_width      = urbango_edge_options()->getOptionValue( 'footer_top_border_width' );
		
		if ( ! empty( $background_color ) ) {
			$item_styles['background-color'] = $background_color;
		}
		
		if ( ! empty( $border_color ) ) {
			$item_inner_styles['border-color'] = $border_color;
		}
		
		if ( $border_width !== '' ) {
			$item_inner_styles['border-width'] = urbango_edge_filter_px( $border_width ) . 'px';
		}
		
		echo urbango_edge_dynamic_css( '.edgtf-page-footer .edgtf-footer-top-holder', $item_styles );
		echo urbango_edge_dynamic_css( '.edgtf-page-footer .edgtf-footer-top-holder .edgtf-footer-top-inner', $item_inner_styles );
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_footer_top_general_styles' );
}

if ( ! function_exists( 'urbango_edge_footer_bottom_general_styles' ) ) {
	/**
	 * Generates general custom styles for footer bottom area
	 */
	function urbango_edge_footer_bottom_general_styles() {
		$item_styles       = array();
		$item_inner_styles = array();
		$background_color  = urbango_edge_options()->getOptionValue( 'footer_bottom_background_color' );
		$border_color      = urbango_edge_options()->getOptionValue( 'footer_bottom_border_color' );
		$border_width      = urbango_edge_options()->getOptionValue( 'footer_bottom_border_width' );
		
		if ( ! empty( $background_color ) ) {
			$item_styles['background-color'] = $background_color;
		}
		
		if ( ! empty( $border_color ) ) {
			$item_inner_styles['border-color'] = $border_color;
		}
		
		if ( $border_width !== '' ) {
			$item_inner_styles['border-width'] = urbango_edge_filter_px( $border_width ) . 'px';
		}
		
		echo urbango_edge_dynamic_css( '.edgtf-page-footer .edgtf-footer-bottom-holder', $item_styles );
		echo urbango_edge_dynamic_css( '.edgtf-page-footer .edgtf-footer-bottom-holder .edgtf-footer-bottom-inner', $item_inner_styles );
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_footer_bottom_general_styles' );
}