<?php

if ( ! function_exists( 'urbango_edge_error_404_options_map' ) ) {
	function urbango_edge_error_404_options_map() {
		
		urbango_edge_add_admin_page(
			array(
				'slug'  => '__404_error_page',
				'title' => esc_html__( '404 Error Page', 'urbango' ),
				'icon'  => 'fa fa-exclamation-triangle'
			)
		);
		
		$panel_404_header = urbango_edge_add_admin_panel(
			array(
				'page'  => '__404_error_page',
				'name'  => 'panel_404_header',
				'title' => esc_html__( 'Header', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'      => $panel_404_header,
				'type'        => 'color',
				'name'        => '404_menu_area_background_color_header',
				'label'       => esc_html__( 'Background Color', 'urbango' ),
				'description' => esc_html__( 'Choose a background color for header area', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $panel_404_header,
				'type'          => 'text',
				'name'          => '404_menu_area_background_transparency_header',
				'default_value' => '',
				'label'         => esc_html__( 'Background Transparency', 'urbango' ),
				'description'   => esc_html__( 'Choose a transparency for the header background color (0 = fully transparent, 1 = opaque)', 'urbango' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'      => $panel_404_header,
				'type'        => 'color',
				'name'        => '404_menu_area_border_color_header',
				'label'       => esc_html__( 'Border Color', 'urbango' ),
				'description' => esc_html__( 'Choose a border bottom color for header area', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $panel_404_header,
				'type'          => 'yesno',
				'name'          => '404_menu_area_shadow',
				'default_value' => 'no',
				'label'         => esc_html__( 'Menu Area Shadow', 'urbango' ),
				'description'   => esc_html__( 'Set shadow on menu area', 'urbango' ),
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $panel_404_header,
				'type'          => 'select',
				'name'          => '404_header_style',
				'default_value' => '',
				'label'         => esc_html__( 'Header Skin', 'urbango' ),
				'description'   => esc_html__( 'Choose a header style to make header elements (logo, main menu, side menu button) in that predefined style', 'urbango' ),
				'options'       => array(
					''             => esc_html__( 'Default', 'urbango' ),
					'light-header' => esc_html__( 'Light', 'urbango' ),
					'dark-header'  => esc_html__( 'Dark', 'urbango' )
				)
			)
		);
		
		$panel_404_options = urbango_edge_add_admin_panel(
			array(
				'page'  => '__404_error_page',
				'name'  => 'panel_404_options',
				'title' => esc_html__( '404 Page Options', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent' => $panel_404_options,
				'type'   => 'color',
				'name'   => '404_page_background_color',
				'label'  => esc_html__( 'Background Color', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'      => $panel_404_options,
				'type'        => 'image',
				'name'        => '404_page_background_image',
				'label'       => esc_html__( 'Background Image', 'urbango' ),
				'description' => esc_html__( 'Choose a background image for 404 page', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'      => $panel_404_options,
				'type'        => 'image',
				'name'        => '404_page_background_pattern_image',
				'label'       => esc_html__( 'Pattern Background Image', 'urbango' ),
				'description' => esc_html__( 'Choose a pattern image for 404 page', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'      => $panel_404_options,
				'type'        => 'image',
				'name'        => '404_page_title_image',
				'label'       => esc_html__( 'Title Image', 'urbango' ),
				'description' => esc_html__( 'Choose a background image for displaying above 404 page Title', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $panel_404_options,
				'type'          => 'text',
				'name'          => '404_title',
				'default_value' => '',
				'label'         => esc_html__( 'Title', 'urbango' ),
				'description'   => esc_html__( 'Enter title for 404 page. Default label is "404".', 'urbango' )
			)
		);
		
		$first_level_group = urbango_edge_add_admin_group(
			array(
				'parent'      => $panel_404_options,
				'name'        => 'first_level_group',
				'title'       => esc_html__( 'Title Style', 'urbango' ),
				'description' => esc_html__( 'Define styles for 404 page title', 'urbango' )
			)
		);
		
		$first_level_row1 = urbango_edge_add_admin_row(
			array(
				'parent' => $first_level_group,
				'name'   => 'first_level_row1'
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent' => $first_level_row1,
				'type'   => 'colorsimple',
				'name'   => '404_title_color',
				'label'  => esc_html__( 'Text Color', 'urbango' ),
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $first_level_row1,
				'type'          => 'fontsimple',
				'name'          => '404_title_google_fonts',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'urbango' ),
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $first_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_title_font_size',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'urbango' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $first_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_title_line_height',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'urbango' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$first_level_row2 = urbango_edge_add_admin_row(
			array(
				'parent' => $first_level_group,
				'name'   => 'first_level_row2',
				'next'   => true
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_title_font_style',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'urbango' ),
				'options'       => urbango_edge_get_font_style_array()
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_title_font_weight',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'urbango' ),
				'options'       => urbango_edge_get_font_weight_array()
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'textsimple',
				'name'          => '404_title_letter_spacing',
				'default_value' => '',
				'label'         => esc_html__( 'Letter Spacing', 'urbango' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $first_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_title_text_transform',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'urbango' ),
				'options'       => urbango_edge_get_text_transform_array()
			)
		);

        $first_level_group_responsive = urbango_edge_add_admin_group(
            array(
                'parent'      => $panel_404_options,
                'name'        => 'first_level_group_responsive',
                'title'       => esc_html__( 'Title Style Responsive', 'urbango' ),
                'description' => esc_html__( 'Define responsive styles for 404 page title (under 680px)', 'urbango' )
            )
        );

        $first_level_row3 = urbango_edge_add_admin_row(
            array(
                'parent' => $first_level_group_responsive,
                'name'   => 'first_level_row3'
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $first_level_row3,
                'type'          => 'textsimple',
                'name'          => '404_title_responsive_font_size',
                'default_value' => '',
                'label'         => esc_html__( 'Font Size', 'urbango' ),
                'args'          => array(
                    'suffix' => 'px'
                )
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $first_level_row3,
                'type'          => 'textsimple',
                'name'          => '404_title_responsive_line_height',
                'default_value' => '',
                'label'         => esc_html__( 'Line Height', 'urbango' ),
                'args'          => array(
                    'suffix' => 'px'
                )
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $first_level_row3,
                'type'          => 'textsimple',
                'name'          => '404_title_responsive_letter_spacing',
                'default_value' => '',
                'label'         => esc_html__( 'Letter Spacing', 'urbango' ),
                'args'          => array(
                    'suffix' => 'px'
                )
            )
        );
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $panel_404_options,
				'type'          => 'text',
				'name'          => '404_text',
				'default_value' => '',
				'label'         => esc_html__( 'Text', 'urbango' ),
				'description'   => esc_html__( 'Enter text for 404 page.', 'urbango' )
			)
		);
		
		$third_level_group = urbango_edge_add_admin_group(
			array(
				'parent'      => $panel_404_options,
				'name'        => '$third_level_group',
				'title'       => esc_html__( 'Text Style', 'urbango' ),
				'description' => esc_html__( 'Define styles for 404 page text', 'urbango' )
			)
		);
		
		$third_level_row1 = urbango_edge_add_admin_row(
			array(
				'parent' => $third_level_group,
				'name'   => '$third_level_row1'
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent' => $third_level_row1,
				'type'   => 'colorsimple',
				'name'   => '404_text_color',
				'label'  => esc_html__( 'Text Color', 'urbango' ),
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $third_level_row1,
				'type'          => 'fontsimple',
				'name'          => '404_text_google_fonts',
				'default_value' => '-1',
				'label'         => esc_html__( 'Font Family', 'urbango' ),
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $third_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_text_font_size',
				'default_value' => '',
				'label'         => esc_html__( 'Font Size', 'urbango' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $third_level_row1,
				'type'          => 'textsimple',
				'name'          => '404_text_line_height',
				'default_value' => '',
				'label'         => esc_html__( 'Line Height', 'urbango' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		$third_level_row2 = urbango_edge_add_admin_row(
			array(
				'parent' => $third_level_group,
				'name'   => '$third_level_row2',
				'next'   => true
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_text_font_style',
				'default_value' => '',
				'label'         => esc_html__( 'Font Style', 'urbango' ),
				'options'       => urbango_edge_get_font_style_array()
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_text_font_weight',
				'default_value' => '',
				'label'         => esc_html__( 'Font Weight', 'urbango' ),
				'options'       => urbango_edge_get_font_weight_array()
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'textsimple',
				'name'          => '404_text_letter_spacing',
				'default_value' => '',
				'label'         => esc_html__( 'Letter Spacing', 'urbango' ),
				'args'          => array(
					'suffix' => 'px'
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $third_level_row2,
				'type'          => 'selectblanksimple',
				'name'          => '404_text_text_transform',
				'default_value' => '',
				'label'         => esc_html__( 'Text Transform', 'urbango' ),
				'options'       => urbango_edge_get_text_transform_array()
			)
		);

        $third_level_group_responsive = urbango_edge_add_admin_group(
            array(
                'parent'      => $panel_404_options,
                'name'        => 'third_level_group_responsive',
                'title'       => esc_html__( 'Text Style Responsive', 'urbango' ),
                'description' => esc_html__( 'Define responsive styles for 404 page text (under 680px)', 'urbango' )
            )
        );

        $third_level_row3 = urbango_edge_add_admin_row(
            array(
                'parent' => $third_level_group_responsive,
                'name'   => 'third_level_row3'
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $third_level_row3,
                'type'          => 'textsimple',
                'name'          => '404_text_responsive_font_size',
                'default_value' => '',
                'label'         => esc_html__( 'Font Size', 'urbango' ),
                'args'          => array(
                    'suffix' => 'px'
                )
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $third_level_row3,
                'type'          => 'textsimple',
                'name'          => '404_text_responsive_line_height',
                'default_value' => '',
                'label'         => esc_html__( 'Line Height', 'urbango' ),
                'args'          => array(
                    'suffix' => 'px'
                )
            )
        );

        urbango_edge_add_admin_field(
            array(
                'parent'        => $third_level_row3,
                'type'          => 'textsimple',
                'name'          => '404_text_responsive_letter_spacing',
                'default_value' => '',
                'label'         => esc_html__( 'Letter Spacing', 'urbango' ),
                'args'          => array(
                    'suffix' => 'px'
                )
            )
        );
		
		urbango_edge_add_admin_field(
			array(
				'parent'      => $panel_404_options,
				'type'        => 'text',
				'name'        => '404_back_to_home',
				'label'       => esc_html__( 'Back to Home Button Label', 'urbango' ),
				'description' => esc_html__( 'Enter label for "Back to home" button', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'parent'        => $panel_404_options,
				'type'          => 'select',
				'name'          => '404_button_style',
				'default_value' => '',
				'label'         => esc_html__( 'Button Skin', 'urbango' ),
				'description'   => esc_html__( 'Choose a style to make Back to Home button in that predefined style', 'urbango' ),
				'options'       => array(
					''            => esc_html__( 'Default', 'urbango' ),
					'light-style' => esc_html__( 'Light', 'urbango' )
				)
			)
		);
		
		$panel_404_footer = urbango_edge_add_admin_panel(array(
			'page' => '__404_error_page',
			'name'	=> 'panel_404_footer',
			'title'	=> esc_html__('404 Page Footer', 'urbango'),
		));
		
		urbango_edge_add_admin_field(
			array(
				'type' => 'select',
				'name' => '404_show_footer_top',
				'default_value' => '',
				'label' => esc_html__('Show Footer Top', 'urbango'),
				'description' => esc_html__('Enabling this option will show Footer Top area on 404 page', 'urbango'),
				'parent' => $panel_404_footer,
				'options'     => array(
					''		=> esc_html__('Default', 'urbango'),
					'no'	=> esc_html__('No', 'urbango'),
					'yes'	=> esc_html__('Yes', 'urbango')
				)
			)
		);
		urbango_edge_add_admin_field(
			array(
				'type' => 'select',
				'name' => '404_show_footer_bottom',
				'default_value' => '',
				'label' => esc_html__('Show Footer Bottom', 'urbango'),
				'description' => esc_html__('Enabling this option will show Footer Bottom area on 404 page', 'urbango'),
				'parent' => $panel_404_footer,
				'options'     => array(
					''		=> esc_html__('Default', 'urbango'),
					'no'	=> esc_html__('No', 'urbango'),
					'yes'	=> esc_html__('Yes', 'urbango')
				)
			)
		);
	}
	
	add_action( 'urbango_edge_action_options_map', 'urbango_edge_error_404_options_map', urbango_edge_set_options_map_position( '404' ) );
}