<?php

/*** Post Settings ***/

if ( ! function_exists( 'urbango_edge_map_post_meta' ) ) {
	function urbango_edge_map_post_meta() {
		
		$post_meta_box = urbango_edge_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Post', 'urbango' ),
				'name'  => 'post-meta'
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_show_title_area_blog_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'urbango' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single post page', 'urbango' ),
				'parent'        => $post_meta_box,
				'options'       => urbango_edge_get_yes_no_select_array()
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_blog_single_sidebar_layout_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Sidebar Layout', 'urbango' ),
				'description'   => esc_html__( 'Choose a sidebar layout for Blog single page', 'urbango' ),
				'default_value' => '',
				'parent'        => $post_meta_box,
                'options'       => urbango_edge_get_custom_sidebars_options( true )
			)
		);
		
		$urbango_custom_sidebars = urbango_edge_get_custom_sidebars();
		if ( is_array( $urbango_custom_sidebars ) && count( $urbango_custom_sidebars ) > 0 ) {
			urbango_edge_create_meta_box_field( array(
				'name'        => 'edgtf_blog_single_custom_sidebar_area_meta',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'urbango' ),
				'description' => esc_html__( 'Choose a sidebar to display on Blog single page. Default sidebar is "Sidebar"', 'urbango' ),
				'parent'      => $post_meta_box,
				'options'     => urbango_edge_get_custom_sidebars(),
				'args' => array(
					'select2' => true
				)
			) );
		}
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_blog_list_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Blog List Image', 'urbango' ),
				'description' => esc_html__( 'Choose an Image for displaying in blog list. If not uploaded, featured image will be shown.', 'urbango' ),
				'parent'      => $post_meta_box
			)
		);

		do_action('urbango_edge_action_blog_post_meta', $post_meta_box);
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_edge_map_post_meta', 20 );
}
