<?php

if ( ! function_exists( 'urbango_edge_map_post_video_meta' ) ) {
	function urbango_edge_map_post_video_meta() {
		$video_post_format_meta_box = urbango_edge_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'urbango' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'urbango' ),
				'description'   => esc_html__( 'Choose video type', 'urbango' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'urbango' ),
					'self'            => esc_html__( 'Self Hosted', 'urbango' )
				)
			)
		);
		
		$edgtf_video_embedded_container = urbango_edge_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name'   => 'edgtf_video_embedded_container'
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'urbango' ),
				'description' => esc_html__( 'Enter Video URL', 'urbango' ),
				'parent'      => $edgtf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'edgtf_video_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'urbango' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'urbango' ),
				'parent'      => $edgtf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'edgtf_video_type_meta' => 'self'
					)
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'urbango' ),
				'description' => esc_html__( 'Enter video image', 'urbango' ),
				'parent'      => $edgtf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'edgtf_video_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_edge_map_post_video_meta', 22 );
}