<?php

if ( ! function_exists( 'urbango_edge_map_post_audio_meta' ) ) {
	function urbango_edge_map_post_audio_meta() {
		$audio_post_format_meta_box = urbango_edge_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'urbango' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'urbango' ),
				'description'   => esc_html__( 'Choose audio type', 'urbango' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'urbango' ),
					'self'            => esc_html__( 'Self Hosted', 'urbango' )
				)
			)
		);
		
		$edgtf_audio_embedded_container = urbango_edge_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'edgtf_audio_embedded_container'
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'urbango' ),
				'description' => esc_html__( 'Enter audio URL', 'urbango' ),
				'parent'      => $edgtf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'edgtf_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'urbango' ),
				'description' => esc_html__( 'Enter audio link', 'urbango' ),
				'parent'      => $edgtf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'edgtf_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_edge_map_post_audio_meta', 23 );
}