<?php

if ( ! function_exists( 'urbango_edge_reset_options_map' ) ) {
	/**
	 * Reset options panel
	 */
	function urbango_edge_reset_options_map() {
		
		urbango_edge_add_admin_page(
			array(
				'slug'  => '_reset_page',
				'title' => esc_html__( 'Reset', 'urbango' ),
				'icon'  => 'fa fa-retweet'
			)
		);
		
		$panel_reset = urbango_edge_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' => esc_html__( 'Reset', 'urbango' )
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'reset_to_defaults',
				'default_value' => 'no',
				'label'         => esc_html__( 'Reset to Defaults', 'urbango' ),
				'description'   => esc_html__( 'This option will reset all Select Options values to defaults', 'urbango' ),
				'parent'        => $panel_reset
			)
		);
	}
	
	add_action( 'urbango_edge_action_options_map', 'urbango_edge_reset_options_map', urbango_edge_set_options_map_position( 'reset' ) );
}