<?php

if ( ! function_exists( 'urbango_edge_map_general_meta' ) ) {
	function urbango_edge_map_general_meta() {
		
		$general_meta_box = urbango_edge_create_meta_box(
			array(
				'scope' => apply_filters( 'urbango_edge_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'general_meta' ),
				'title' => esc_html__( 'General', 'urbango' ),
				'name'  => 'general_meta'
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_page_slider_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Slider Shortcode', 'urbango' ),
				'description' => esc_html__( 'Paste your slider shortcode here', 'urbango' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		/***************** Content Layout - begin **********************/
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_page_content_behind_header_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Always put content behind header', 'urbango' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'urbango' ),
				'parent'        => $general_meta_box
			)
		);
		
		$edgtf_content_padding_group = urbango_edge_add_admin_group(
			array(
				'name'        => 'content_padding_group',
				'title'       => esc_html__( 'Content Styles', 'urbango' ),
				'description' => esc_html__( 'Define styles for Content area', 'urbango' ),
				'parent'      => $general_meta_box
			)
		);
		
			$edgtf_content_padding_row = urbango_edge_add_admin_row(
				array(
					'name'   => 'edgtf_content_padding_row',
					'parent' => $edgtf_content_padding_group
				)
			);
			
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_page_background_color_meta',
						'type'        => 'colorsimple',
						'label'       => esc_html__( 'Page Background Color', 'urbango' ),
						'parent'      => $edgtf_content_padding_row
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_page_background_image_meta',
						'type'          => 'imagesimple',
						'label'         => esc_html__( 'Page Background Image', 'urbango' ),
						'parent'        => $edgtf_content_padding_row
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_page_background_repeat_meta',
						'type'          => 'selectsimple',
						'default_value' => '',
						'label'         => esc_html__( 'Page Background Image Repeat', 'urbango' ),
						'options'       => urbango_edge_get_yes_no_select_array(),
						'parent'        => $edgtf_content_padding_row
					)
				);
		
			$edgtf_content_padding_row_1 = urbango_edge_add_admin_row(
				array(
					'name'   => 'edgtf_content_padding_row_1',
					'next'   => true,
					'parent' => $edgtf_content_padding_group
				)
			);
		
				urbango_edge_create_meta_box_field(
					array(
						'name'   => 'edgtf_page_content_padding',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Content Padding (eg. 10px 5px 10px 5px)', 'urbango' ),
						'parent' => $edgtf_content_padding_row_1,
						'args'        => array(
							'col_width' => 4
						)
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'    => 'edgtf_page_content_padding_mobile',
						'type'    => 'textsimple',
						'label'   => esc_html__( 'Content Padding for mobile (eg. 10px 5px 10px 5px)', 'urbango' ),
						'parent'  => $edgtf_content_padding_row_1,
						'args'        => array(
							'col_width' => 4
						)
					)
				);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_initial_content_width_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Initial Width of Content', 'urbango' ),
				'description'   => esc_html__( 'Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'urbango' ),
				'parent'        => $general_meta_box,
				'options'       => array(
					''                => esc_html__( 'Default', 'urbango' ),
					'edgtf-grid-1300' => esc_html__( '1300px', 'urbango' ),
					'edgtf-grid-1200' => esc_html__( '1200px', 'urbango' ),
					'edgtf-grid-1100' => esc_html__( '1100px', 'urbango' ),
					'edgtf-grid-1000' => esc_html__( '1000px', 'urbango' ),
					'edgtf-grid-800'  => esc_html__( '800px', 'urbango' )
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_page_grid_space_meta',
				'type'        => 'select',
				'default_value' => '',
				'label'       => esc_html__( 'Grid Layout Space', 'urbango' ),
				'description' => esc_html__( 'Choose a space between content layout and sidebar layout for your page', 'urbango' ),
				'options'     => urbango_edge_get_space_between_items_array( true ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Content Layout - end **********************/
		
		/***************** Boxed Layout - begin **********************/
		
		urbango_edge_create_meta_box_field(
			array(
				'name'    => 'edgtf_boxed_meta',
				'type'    => 'select',
				'label'   => esc_html__( 'Boxed Layout', 'urbango' ),
				'parent'  => $general_meta_box,
				'options' => urbango_edge_get_yes_no_select_array()
			)
		);
		
			$boxed_container_meta = urbango_edge_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'boxed_container_meta',
					'dependency' => array(
						'hide' => array(
							'edgtf_boxed_meta' => array( '', 'no' )
						)
					)
				)
			);
		
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_page_background_color_in_box_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Page Background Color', 'urbango' ),
						'description' => esc_html__( 'Choose the page background color outside box', 'urbango' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_boxed_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'urbango' ),
						'description' => esc_html__( 'Choose an image to be displayed in background', 'urbango' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_boxed_pattern_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Pattern', 'urbango' ),
						'description' => esc_html__( 'Choose an image to be used as background pattern', 'urbango' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'          => 'edgtf_boxed_background_image_attachment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Attachment', 'urbango' ),
						'description'   => esc_html__( 'Choose background image attachment', 'urbango' ),
						'parent'        => $boxed_container_meta,
						'options'       => array(
							''       => esc_html__( 'Default', 'urbango' ),
							'fixed'  => esc_html__( 'Fixed', 'urbango' ),
							'scroll' => esc_html__( 'Scroll', 'urbango' )
						)
					)
				);
		
		/***************** Boxed Layout - end **********************/
		
		/***************** Passepartout Layout - begin **********************/
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_paspartu_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Passepartout', 'urbango' ),
				'description'   => esc_html__( 'Enabling this option will display passepartout around site content', 'urbango' ),
				'parent'        => $general_meta_box,
				'options'       => urbango_edge_get_yes_no_select_array(),
			)
		);
		
			$paspartu_container_meta = urbango_edge_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'edgtf_paspartu_container_meta',
					'dependency' => array(
						'hide' => array(
							'edgtf_paspartu_meta'  => array('','no')
						)
					)
				)
			);
		
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_paspartu_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Passepartout Color', 'urbango' ),
						'description' => esc_html__( 'Choose passepartout color, default value is #ffffff', 'urbango' ),
						'parent'      => $paspartu_container_meta
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_paspartu_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Passepartout Size', 'urbango' ),
						'description' => esc_html__( 'Enter size amount for passepartout', 'urbango' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
		
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_paspartu_responsive_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Responsive Passepartout Size', 'urbango' ),
						'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (tablets and mobiles view)', 'urbango' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
				
				urbango_edge_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'edgtf_disable_top_paspartu_meta',
						'label'         => esc_html__( 'Disable Top Passepartout', 'urbango' ),
						'options'       => urbango_edge_get_yes_no_select_array(),
					)
				);
		
				urbango_edge_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'edgtf_enable_fixed_paspartu_meta',
						'label'         => esc_html__( 'Enable Fixed Passepartout', 'urbango' ),
						'description'   => esc_html__( 'Enabling this option will set fixed passepartout for your screens', 'urbango' ),
						'options'       => urbango_edge_get_yes_no_select_array(),
					)
				);
		
		/***************** Passepartout Layout - end **********************/
		
		/***************** Smooth Page Transitions Layout - begin **********************/
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_smooth_page_transitions_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Smooth Page Transitions', 'urbango' ),
				'description'   => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links', 'urbango' ),
				'parent'        => $general_meta_box,
				'options'       => urbango_edge_get_yes_no_select_array()
			)
		);
		
			$page_transitions_container_meta = urbango_edge_add_admin_container(
				array(
					'parent'     => $general_meta_box,
					'name'       => 'page_transitions_container_meta',
					'dependency' => array(
						'hide' => array(
							'edgtf_smooth_page_transitions_meta' => array( '', 'no' )
						)
					)
				)
			);
		
				urbango_edge_create_meta_box_field(
					array(
						'name'        => 'edgtf_page_transition_preloader_meta',
						'type'        => 'select',
						'label'       => esc_html__( 'Enable Preloading Animation', 'urbango' ),
						'description' => esc_html__( 'Enabling this option will display an animated preloader while the page content is loading', 'urbango' ),
						'parent'      => $page_transitions_container_meta,
						'options'     => urbango_edge_get_yes_no_select_array()
					)
				);
		
				$page_transition_preloader_container_meta = urbango_edge_add_admin_container(
					array(
						'parent'     => $page_transitions_container_meta,
						'name'       => 'page_transition_preloader_container_meta',
						'dependency' => array(
							'hide' => array(
								'edgtf_page_transition_preloader_meta' => array( '', 'no' )
							)
						)
					)
				);
				
					urbango_edge_create_meta_box_field(
						array(
							'name'   => 'edgtf_smooth_pt_bgnd_color_meta',
							'type'   => 'color',
							'label'  => esc_html__( 'Page Loader Background Color', 'urbango' ),
							'parent' => $page_transition_preloader_container_meta
						)
					);
					
					$group_pt_spinner_animation_meta = urbango_edge_add_admin_group(
						array(
							'name'        => 'group_pt_spinner_animation_meta',
							'title'       => esc_html__( 'Loader Style', 'urbango' ),
							'description' => esc_html__( 'Define styles for loader spinner animation', 'urbango' ),
							'parent'      => $page_transition_preloader_container_meta
						)
					);
					
					$row_pt_spinner_animation_meta = urbango_edge_add_admin_row(
						array(
							'name'   => 'row_pt_spinner_animation_meta',
							'parent' => $group_pt_spinner_animation_meta
						)
					);
					
					urbango_edge_create_meta_box_field(
						array(
							'type'    => 'selectsimple',
							'name'    => 'edgtf_smooth_pt_spinner_type_meta',
							'label'   => esc_html__( 'Spinner Type', 'urbango' ),
							'parent'  => $row_pt_spinner_animation_meta,
							'options' => array(
								''                      => esc_html__( 'Default', 'urbango' ),
								'rotate_circles'        => esc_html__( 'Rotate Circles', 'urbango' ),
								'pulse'                 => esc_html__( 'Pulse', 'urbango' ),
								'double_pulse'          => esc_html__( 'Double Pulse', 'urbango' ),
								'cube'                  => esc_html__( 'Cube', 'urbango' ),
								'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'urbango' ),
								'stripes'               => esc_html__( 'Stripes', 'urbango' ),
								'wave'                  => esc_html__( 'Wave', 'urbango' ),
								'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'urbango' ),
								'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'urbango' ),
								'atom'                  => esc_html__( 'Atom', 'urbango' ),
								'clock'                 => esc_html__( 'Clock', 'urbango' ),
								'mitosis'               => esc_html__( 'Mitosis', 'urbango' ),
								'lines'                 => esc_html__( 'Lines', 'urbango' ),
								'fussion'               => esc_html__( 'Fussion', 'urbango' ),
								'wave_circles'          => esc_html__( 'Wave Circles', 'urbango' ),
								'pulse_circles'         => esc_html__( 'Pulse Circles', 'urbango' )
							)
						)
					);
					
					urbango_edge_create_meta_box_field(
						array(
							'type'   => 'colorsimple',
							'name'   => 'edgtf_smooth_pt_spinner_color_meta',
							'label'  => esc_html__( 'Spinner Color', 'urbango' ),
							'parent' => $row_pt_spinner_animation_meta
						)
					);
					
					urbango_edge_create_meta_box_field(
						array(
							'name'        => 'edgtf_page_transition_fadeout_meta',
							'type'        => 'select',
							'label'       => esc_html__( 'Enable Fade Out Animation', 'urbango' ),
							'description' => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'urbango' ),
							'options'     => urbango_edge_get_yes_no_select_array(),
							'parent'      => $page_transitions_container_meta
						
						)
					);
		
		/***************** Smooth Page Transitions Layout - end **********************/
		
		/***************** Comments Layout - begin **********************/
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_page_comments_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Show Comments', 'urbango' ),
				'description' => esc_html__( 'Enabling this option will show comments on your page', 'urbango' ),
				'parent'      => $general_meta_box,
				'options'     => urbango_edge_get_yes_no_select_array()
			)
		);
		
		/***************** Comments Layout - end **********************/
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_edge_map_general_meta', 10 );
}

if ( ! function_exists( 'urbango_edge_container_background_style' ) ) {
	/**
	 * Function that return container style
	 */
	function urbango_edge_container_background_style( $style ) {
		$page_id      = urbango_edge_get_page_id();
		$class_prefix = urbango_edge_get_unique_page_class( $page_id, true );
		
		$container_selector = array(
			$class_prefix . ' .edgtf-content'
		);
		
		$container_class        = array();
		$page_background_color  = get_post_meta( $page_id, 'edgtf_page_background_color_meta', true );
		$page_background_image  = get_post_meta( $page_id, 'edgtf_page_background_image_meta', true );
		$page_background_repeat = get_post_meta( $page_id, 'edgtf_page_background_repeat_meta', true );
		
		if ( ! empty( $page_background_color ) ) {
			$container_class['background-color'] = $page_background_color;
		}
		
		if ( ! empty( $page_background_image ) ) {
			$container_class['background-image'] = 'url(' . esc_url( $page_background_image ) . ')';
			
			if ( $page_background_repeat === 'yes' ) {
				$container_class['background-repeat']   = 'repeat';
				$container_class['background-position'] = '0 0';
			} else {
				$container_class['background-repeat']   = 'no-repeat';
				$container_class['background-position'] = 'center 0';
				$container_class['background-size']     = 'cover';
			}
		}
		
		$current_style = urbango_edge_dynamic_css( $container_selector, $container_class );
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'urbango_edge_filter_add_page_custom_style', 'urbango_edge_container_background_style' );
}