<?php

if ( ! function_exists( 'urbango_edge_design_styles' ) ) {
	/**
	 * Generates general custom styles
	 */
	function urbango_edge_design_styles() {
		$font_family = urbango_edge_options()->getOptionValue( 'google_fonts' );
		if ( ! empty( $font_family ) && urbango_edge_is_font_option_valid( $font_family ) ) {
			$font_family_selector = array(
				'body'
			);
			echo urbango_edge_dynamic_css( $font_family_selector, array( 'font-family' => urbango_edge_get_font_option_val( $font_family ) ) );
		}
		
		$first_main_color = urbango_edge_options()->getOptionValue( 'first_color' );
		if ( ! empty( $first_main_color ) ) {
			$color_selector = $color_important_selector = $background_color_selector = $background_color_important_selector = $border_color_selector = $border_color_important_selector = $fill_color_selector = $fill_color_important_selector = $stroke_color_selector = $stroke_color_important_selector = array();
			
			// Include first main color selectors
			include_once 'parts/first-main-color.php';
			
			if ( urbango_edge_is_woocommerce_installed() ) {
				$woo_color_selector = $woo_color_important_selector = $woo_background_color_selector = $woo_background_color_important_selector = $woo_border_color_selector = $woo_border_color_important_selector = $woo_fill_color_selector = $woo_fill_color_important_selector = $woo_stroke_color_selector = $woo_stroke_color_important_selector = array();
				
				// Include first main color WooCommerce selectors
				include_once 'parts/woocommerce-first-main-color.php';
				
				if ( isset( $woo_color_selector ) && ! empty( $woo_color_selector ) ) {
					$color_selector = array_merge( $color_selector, $woo_color_selector );
				}
				
				if ( isset( $woo_color_important_selector ) && ! empty( $woo_color_important_selector ) ) {
					$color_important_selector = array_merge( $color_important_selector, $woo_color_important_selector );
				}
				
				if ( isset( $woo_background_color_selector ) && ! empty( $woo_background_color_selector ) ) {
					$background_color_selector = array_merge( $background_color_selector, $woo_background_color_selector );
				}
				
				if ( isset( $woo_background_color_important_selector ) && ! empty( $woo_background_color_important_selector ) ) {
					$background_color_important_selector = array_merge( $background_color_important_selector, $woo_background_color_important_selector );
				}
				
				if ( isset( $woo_border_color_selector ) && ! empty( $woo_border_color_selector ) ) {
					$border_color_selector = array_merge( $border_color_selector, $woo_border_color_selector );
				}
				
				if ( isset( $woo_border_color_important_selector ) && ! empty( $woo_border_color_important_selector ) ) {
					$border_color_important_selector = array_merge( $border_color_important_selector, $woo_border_color_important_selector );
				}
				
				if ( isset( $woo_fill_color_selector ) && ! empty( $woo_fill_color_selector ) ) {
					$fill_color_selector = array_merge( $fill_color_selector, $woo_fill_color_selector );
				}
				
				if ( isset( $woo_fill_color_important_selector ) && ! empty( $woo_fill_color_important_selector ) ) {
					$fill_color_important_selector = array_merge( $fill_color_important_selector, $woo_fill_color_important_selector );
				}
				
				if ( isset( $woo_stroke_color_selector ) && ! empty( $woo_stroke_color_selector ) ) {
					$stroke_color_selector = array_merge( $stroke_color_selector, $woo_stroke_color_selector );
				}
				
				if ( isset( $woo_stroke_color_important_selector ) && ! empty( $woo_stroke_color_important_selector ) ) {
					$stroke_color_important_selector = array_merge( $stroke_color_important_selector, $woo_stroke_color_important_selector );
				}
			}
			
			if ( isset( $color_selector ) && ! empty( $color_selector ) ) {
				echo urbango_edge_dynamic_css( $color_selector, array( 'color' => $first_main_color ) );
			}
			
			if ( isset( $color_important_selector ) && ! empty( $color_important_selector ) ) {
				echo urbango_edge_dynamic_css( $color_important_selector, array( 'color' => $first_main_color . '!important' ) );
			}
			
			if ( isset( $background_color_selector ) && ! empty( $background_color_selector ) ) {
				echo urbango_edge_dynamic_css( $background_color_selector, array( 'background-color' => $first_main_color ) );
			}
			
			if ( isset( $background_color_important_selector ) && ! empty( $background_color_important_selector ) ) {
				echo urbango_edge_dynamic_css( $background_color_important_selector, array( 'background-color' => $first_main_color . '!important' ) );
			}
			
			if ( isset( $border_color_selector ) && ! empty( $border_color_selector ) ) {
				echo urbango_edge_dynamic_css( $border_color_selector, array( 'border-color' => $first_main_color ) );
			}
			
			if ( isset( $border_color_important_selector ) && ! empty( $border_color_important_selector ) ) {
				echo urbango_edge_dynamic_css( $border_color_important_selector, array( 'border-color' => $first_main_color . '!important' ) );
			}
			
			if ( isset( $fill_color_selector ) && ! empty( $fill_color_selector ) ) {
				echo urbango_edge_dynamic_css( $fill_color_selector, array( 'fill' => $first_main_color ) );
			}
			
			if ( isset( $fill_color_important_selector ) && ! empty( $fill_color_important_selector ) ) {
				echo urbango_edge_dynamic_css( $fill_color_important_selector, array( 'fill' => $first_main_color . '!important' ) );
			}
			
			if ( isset( $stroke_color_selector ) && ! empty( $stroke_color_selector ) ) {
				echo urbango_edge_dynamic_css( $stroke_color_selector, array( 'stroke' => $first_main_color ) );
			}
			
			if ( isset( $stroke_color_important_selector ) && ! empty( $stroke_color_important_selector ) ) {
				echo urbango_edge_dynamic_css( $stroke_color_important_selector, array( 'stroke' => $first_main_color . '!important' ) );
			}
		}
		
		$second_main_color = urbango_edge_options()->getOptionValue( 'second_color' );
		if ( ! empty( $second_main_color ) ) {
			
			$color_selector = array(
				'.edgtf-comment-rating-box .edgtf-star-rating',
				'.edgtf-claim-opener:hover',
				'.edgtf-membership-main-wrapper .edgtf-lp-section-title .edgtf-lp-st-text a',
				'.edgtf-membership-dashboard-nav-holder ul li.edgtf-active-dash .edgtf-dash-icon',
				'.edgtf-membership-dashboard-nav-holder ul li a:hover .edgtf-dash-icon',
				'.edgtf-category-tabs-holder .edgtf-ct-item-inner:hover .edgtf-ct-icon',
				'.edgtf-listing-list-holder article .edgtf-lli-reviews-count i',
				'.edgtf-listing-list-holder .edgtf-ll-filter-holder .edgtf-filter-section-switch-layout .edgtf-fs-sl-icons a.edgtf-active',
				'.edgtf-listing-list-holder .edgtf-ll-filter-holder .edgtf-filter-section-switch-layout .edgtf-fs-sl-icons a:hover',
				'.edgtf-listing-single-holder .edgtf-ls-title-right-area .edgtf-stars-items',
				'.edgtf-listing-single-holder .edgtf-comment-holder .edgtf-review-rating .edgtf-rating-value',
				'.edgtf-listing-single-holder .edgtf-ls-location .edgtf-ls-business-hours .edgtf-ls-bg-local-time',
				'.edgtf-membership-main-wrapper .edgtf-login-register-content.edgtf-user-not-logged-in .edgtf-wp-section-notice a:hover',
				'.edgtf-login-register-holder .edgtf-wp-section-notice a:hover'
			);
			
			$background_color_selector = array(
				'#submit_comment:hover',
				'.post-password-form input[type=submit]:hover',
				'input.wpcf7-form-control.wpcf7-submit:hover',
				'.edgtf-owl-slider .owl-dots .owl-dot.active span',
				'.edgtf-owl-slider .owl-dots .owl-dot:hover span',
				'.edgtf-blog-holder article .edgtf-post-heading:hover .edgtf-post-date',
				'.edgtf-blog-holder article:hover .edgtf-post-date',
				'.edgtf-blog-holder article.format-quote:hover .edgtf-post-date',
				'.edgtf-blog-holder.edgtf-blog-standard-date-on-image article .edgtf-post-date:hover',
				'.edgtf-blog-list-holder .edgtf-bl-item.edgtf-hovered .edgtf-post-date',
				'.widget.edgtf-search-post-type-widget button:hover',
				'.edgtf-testimonials-holder .edgtf-owl-slider .owl-dots .owl-dot.active span',
				'.edgtf-testimonials-holder .edgtf-owl-slider .owl-dots .owl-dot:hover span',
				'.edgtf-process-holder .edgtf-process-item:hover:before',
				'.edgtf-progress-bar .edgtf-pb-content-holder .edgtf-pb-content',
				'.edgtf-fs-places-geo-radius .noUi-target .noUi-handle',
				'.edgtf-listing-profile-searches .edgtf-query-search-page',
				'.edgtf-category-list-holder .edgtf-cl-item-inner:hover .edgtf-cl-items-count',
				'.edgtf-listing-list-holder article .edgtf-lli-category-holder a.edgtf-is-icon:hover',
				'.edgtf-listing-list-holder article.edgtf-hovered a.edgtf-is-icon',
				'.edgtf-location-banner-holder .edgtf-lb-item:hover .edgtf-lb-items-count',
				'.edgtf-location-list-holder .edgtf-ll-item-inner:hover .edgtf-ll-items-count',
				'.edgtf-wp-register-holder .edgtf-register-notice .edgtf-login-action-btn:hover'
			);
			
			$background_color_important_selector = array(
				'.edgtf-btn.edgtf-btn-solid:not(.edgtf-btn-custom-hover-bg):hover'
			);
			
			$border_color_selector = array(
				'#submit_comment:hover',
				'.post-password-form input[type=submit]:hover',
				'input.wpcf7-form-control.wpcf7-submit:hover',
				'.edgtf-testimonials-holder .edgtf-owl-slider .owl-dots .owl-dot.active span',
				'.edgtf-testimonials-holder .edgtf-owl-slider .owl-dots .owl-dot:hover span',
				'.edgtf-process-holder .edgtf-process-item:hover:before',
				'.edgtf-wp-register-holder .edgtf-register-notice .edgtf-login-action-btn:hover'
			);
			
			$border_color_important_selector = array(
				'.edgtf-btn.edgtf-btn-solid:not(.edgtf-btn-custom-border-hover):hover'
			);
			
			if ( urbango_edge_is_woocommerce_installed() ) {
				
				$woo_color_selector = array(
					'.edgtf-pl-holder .edgtf-pli .edgtf-pli-rating',
					'.edgtf-woo-single-page .woocommerce-tabs #reviews .comment-respond .stars a.active:after',
					'.edgtf-woo-single-page .woocommerce-tabs #reviews .comment-respond .stars a:before',
					'.woocommerce .star-rating',
					'div.woocommerce>.single-product .woocommerce-tabs #reviews .comment-respond .stars a.active:after',
					'div.woocommerce>.single-product .woocommerce-tabs #reviews .comment-respond .stars a:before',
					'.edgtf-woocommerce-page .cart-collaterals .woocommerce-shipping-calculator .shipping-calculator-button:hover',
					'.edgtf-woocommerce-page.woocommerce-account .woocommerce-MyAccount-content>p a:hover',
					'.widget.woocommerce.widget_rating_filter ul li a:hover'
				);
				
				$woo_background_color_selector = array(
					'.woocommerce-page .edgtf-content .wc-forward:not(.added_to_cart):not(.checkout-button):hover',
					'.woocommerce-page .edgtf-content a.added_to_cart:hover',
					'.woocommerce-page .edgtf-content a.button:hover',
					'.woocommerce-page .edgtf-content button[type=submit]:not(.edgtf-search-submit):hover',
					'.woocommerce-page .edgtf-content input[type=submit]:hover',
					'div.woocommerce .wc-forward:not(.added_to_cart):not(.checkout-button):hover',
					'div.woocommerce a.added_to_cart:hover',
					'div.woocommerce a.button:hover',
					'div.woocommerce button[type=submit]:not(.edgtf-search-submit):hover',
					'div.woocommerce input[type=submit]:hover',
					'.woocommerce .edgtf-onsale',
					'.edgtf-pricing-package-page .woocommerce-error .button:hover',
					'.edgtf-pricing-package-page .woocommerce-info .button:hover',
					'.edgtf-pricing-package-page .woocommerce-message .button:hover',
					'.widget.woocommerce.widget_price_filter .price_slider_wrapper .ui-widget-content .ui-slider-handle',
					'.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-image .edgtf-pli-onsale',
					'.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-text-inner .edgtf-pli-add-to-cart.edgtf-default-skin .added_to_cart:hover',
					'.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-text-inner .edgtf-pli-add-to-cart.edgtf-default-skin .button:hover'
				);
				
				$woo_border_color_selector = array(
					'.woocommerce-page .edgtf-content .wc-forward:not(.added_to_cart):not(.checkout-button):hover',
					'.woocommerce-page .edgtf-content a.added_to_cart:hover',
					'.woocommerce-page .edgtf-content a.button:hover',
					'.woocommerce-page .edgtf-content button[type=submit]:not(.edgtf-search-submit):hover',
					'.woocommerce-page .edgtf-content input[type=submit]:hover',
					'div.woocommerce .wc-forward:not(.added_to_cart):not(.checkout-button):hover',
					'div.woocommerce a.added_to_cart:hover',
					'div.woocommerce a.button:hover',
					'div.woocommerce button[type=submit]:not(.edgtf-search-submit):hover',
					'div.woocommerce input[type=submit]:hover',
					'.edgtf-pricing-package-page .woocommerce-error .button:hover',
					'.edgtf-pricing-package-page .woocommerce-info .button:hover',
					'.edgtf-pricing-package-page .woocommerce-message .button:hover',
					'.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-text-inner .edgtf-pli-add-to-cart.edgtf-default-skin .added_to_cart:hover',
					'.edgtf-pl-holder .edgtf-pli-inner .edgtf-pli-text-inner .edgtf-pli-add-to-cart.edgtf-default-skin .button:hover'
				);
				
				if ( isset( $woo_color_selector ) && ! empty( $woo_color_selector ) ) {
					$color_selector = array_merge( $color_selector, $woo_color_selector );
				}
				
				if ( isset( $woo_background_color_selector ) && ! empty( $woo_background_color_selector ) ) {
					$background_color_selector = array_merge( $background_color_selector, $woo_background_color_selector );
				}
				
				if ( isset( $woo_border_color_selector ) && ! empty( $woo_border_color_selector ) ) {
					$border_color_selector = array_merge( $border_color_selector, $woo_border_color_selector );
				}
			}
			
			if ( isset( $color_selector ) && ! empty( $color_selector ) ) {
				echo urbango_edge_dynamic_css( $color_selector, array( 'color' => $second_main_color ) );
			}
			
			if ( isset( $color_important_selector ) && ! empty( $color_important_selector ) ) {
				echo urbango_edge_dynamic_css( $color_important_selector, array( 'color' => $second_main_color . '!important' ) );
			}
			
			if ( isset( $background_color_selector ) && ! empty( $background_color_selector ) ) {
				echo urbango_edge_dynamic_css( $background_color_selector, array( 'background-color' => $second_main_color ) );
			}
			
			if ( isset( $background_color_important_selector ) && ! empty( $background_color_important_selector ) ) {
				echo urbango_edge_dynamic_css( $background_color_important_selector, array( 'background-color' => $second_main_color . '!important' ) );
			}
			
			if ( isset( $border_color_selector ) && ! empty( $border_color_selector ) ) {
				echo urbango_edge_dynamic_css( $border_color_selector, array( 'border-color' => $second_main_color ) );
			}
			
			if ( isset( $border_color_important_selector ) && ! empty( $border_color_important_selector ) ) {
				echo urbango_edge_dynamic_css( $border_color_important_selector, array( 'border-color' => $second_main_color . '!important' ) );
			}
		}
		
		$page_background_color = urbango_edge_options()->getOptionValue( 'page_background_color' );
		if ( ! empty( $page_background_color ) ) {
			$background_color_selector = array(
				'body',
				'.edgtf-content'
			);
			echo urbango_edge_dynamic_css( $background_color_selector, array( 'background-color' => $page_background_color ) );
		}
		
		$page_background_image  = urbango_edge_options()->getOptionValue( 'page_background_image' );
		$page_background_repeat = urbango_edge_options()->getOptionValue( 'page_background_image_repeat' );
		
		if ( ! empty( $page_background_image ) ) {
			
			if ( $page_background_repeat === 'yes' ) {
				$background_image_style = array(
					'background-image'    => 'url(' . esc_url( $page_background_image ) . ')',
					'background-repeat'   => 'repeat',
					'background-position' => '0 0',
				);
			} else {
				$background_image_style = array(
					'background-image'    => 'url(' . esc_url( $page_background_image ) . ')',
					'background-repeat'   => 'no-repeat',
					'background-position' => 'center 0',
					'background-size'     => 'cover'
				);
			}
			
			echo urbango_edge_dynamic_css( '.edgtf-content', $background_image_style );
		}
		
		$selection_color = urbango_edge_options()->getOptionValue( 'selection_color' );
		if ( ! empty( $selection_color ) ) {
			echo urbango_edge_dynamic_css( '::selection', array( 'background' => $selection_color ) );
			echo urbango_edge_dynamic_css( '::-moz-selection', array( 'background' => $selection_color ) );
		}
		
		$preload_background_styles = array();
		
		if ( urbango_edge_options()->getOptionValue( 'preload_pattern_image' ) !== "" ) {
			$preload_background_styles['background-image'] = 'url(' . urbango_edge_options()->getOptionValue( 'preload_pattern_image' ) . ') !important';
		}
		
		echo urbango_edge_dynamic_css( '.edgtf-preload-background', $preload_background_styles );
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_design_styles' );
}

if ( ! function_exists( 'urbango_edge_content_styles' ) ) {
	function urbango_edge_content_styles() {
		$content_style = array();
		
		$padding = urbango_edge_options()->getOptionValue( 'content_padding' );
		if ( $padding !== '' ) {
			$content_style['padding'] = $padding;
		}
		
		$content_selector = array(
			'.edgtf-content .edgtf-content-inner > .edgtf-full-width > .edgtf-full-width-inner',
		);
		
		echo urbango_edge_dynamic_css( $content_selector, $content_style );
		
		$content_style_in_grid = array();
		
		$padding_in_grid = urbango_edge_options()->getOptionValue( 'content_padding_in_grid' );
		if ( $padding_in_grid !== '' ) {
			$content_style_in_grid['padding'] = $padding_in_grid;
		}
		
		$content_selector_in_grid = array(
			'.edgtf-content .edgtf-content-inner > .edgtf-container > .edgtf-container-inner',
		);
		
		echo urbango_edge_dynamic_css( $content_selector_in_grid, $content_style_in_grid );
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_content_styles' );
}

if ( ! function_exists( 'urbango_edge_h1_styles' ) ) {
	function urbango_edge_h1_styles() {
		$margin_top    = urbango_edge_options()->getOptionValue( 'h1_margin_top' );
		$margin_bottom = urbango_edge_options()->getOptionValue( 'h1_margin_bottom' );
		
		$item_styles = urbango_edge_get_typography_styles( 'h1' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = urbango_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = urbango_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h1'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo urbango_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_h1_styles' );
}

if ( ! function_exists( 'urbango_edge_h2_styles' ) ) {
	function urbango_edge_h2_styles() {
		$margin_top    = urbango_edge_options()->getOptionValue( 'h2_margin_top' );
		$margin_bottom = urbango_edge_options()->getOptionValue( 'h2_margin_bottom' );
		
		$item_styles = urbango_edge_get_typography_styles( 'h2' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = urbango_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = urbango_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h2'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo urbango_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_h2_styles' );
}

if ( ! function_exists( 'urbango_edge_h3_styles' ) ) {
	function urbango_edge_h3_styles() {
		$margin_top    = urbango_edge_options()->getOptionValue( 'h3_margin_top' );
		$margin_bottom = urbango_edge_options()->getOptionValue( 'h3_margin_bottom' );
		
		$item_styles = urbango_edge_get_typography_styles( 'h3' );
		
		$other_item_selector = array(
			'.edgtf-woocommerce-page .cart_totals > h2',
			'.edgtf-woocommerce-page .cross-sells > h2',
			'.edgtf-woocommerce-page .cart-empty',
			'div.woocommerce > .single-product .related.products > h2',
			'div.woocommerce > .single-product .upsells.products > h2',
			'.edgtf-woo-single-page .related.products > h2',
			'.edgtf-woo-single-page .upsells.products > h2'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo urbango_edge_dynamic_css( $other_item_selector, $item_styles );
		}
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = urbango_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = urbango_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h3'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo urbango_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_h3_styles' );
}

if ( ! function_exists( 'urbango_edge_h4_styles' ) ) {
	function urbango_edge_h4_styles() {
		$margin_top    = urbango_edge_options()->getOptionValue( 'h4_margin_top' );
		$margin_bottom = urbango_edge_options()->getOptionValue( 'h4_margin_bottom' );
		
		$item_styles = urbango_edge_get_typography_styles( 'h4' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = urbango_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = urbango_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h4'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo urbango_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_h4_styles' );
}

if ( ! function_exists( 'urbango_edge_h5_styles' ) ) {
	function urbango_edge_h5_styles() {
		$margin_top    = urbango_edge_options()->getOptionValue( 'h5_margin_top' );
		$margin_bottom = urbango_edge_options()->getOptionValue( 'h5_margin_bottom' );
		
		$item_styles = urbango_edge_get_typography_styles( 'h5' );
		
		$other_item_selector = array(
			'.edgtf-blog-pagination ul li a',
			'.edgtf-bl-standard-pagination ul li a',
			'.edgtf-tabs .edgtf-tabs-nav li a',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-1 h3',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-2 h3',
			'.edgtf-woocommerce-page .woocommerce-checkout h3#order_review_heading',
			'.edgtf-woocommerce-page.woocommerce-order-received .woocommerce h2',
			'.edgtf-woocommerce-page.woocommerce-view-order .woocommerce h2',
			'.woocommerce-pagination ul li a',
			'.woocommerce-pagination ul li span',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce-MyAccount-navigation ul li a',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce .col2-set.addresses h3',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce form.edit-account fieldset > legend',
			'.edgtf-woocommerce-page.woocommerce-account .vc_row .woocommerce > h2',
			'.edgtf-woocommerce-page.woocommerce-account.woocommerce-edit-address .woocommerce form h3',
			'div.woocommerce > .single-product .woocommerce-tabs ul.tabs > li a',
			'div.woocommerce > .single-product .woocommerce-tabs #reviews h2',
			'div.woocommerce > .single-product .woocommerce-tabs #reviews .comment-respond .comment-reply-title',
			'.edgtf-woo-single-page .woocommerce-tabs ul.tabs > li a',
			'.edgtf-woo-single-page .woocommerce-tabs #reviews h2',
			'.edgtf-woo-single-page .woocommerce-tabs #reviews .comment-respond .comment-reply-title',
			'.edgtf-listing-profile-page .edgtf-profile-info p > span',
			'.edgtf-category-list-holder .edgtf-cl-items-count',
			'.edgtf-location-banner-holder .edgtf-lb-items-count',
			'.edgtf-location-list-holder .edgtf-ll-items-count',
			'.edgtf-membership-main-wrapper .edgtf-login-register-content.edgtf-user-not-logged-in.ui-tabs ul li a'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo urbango_edge_dynamic_css( $other_item_selector, $item_styles );
		}
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = urbango_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = urbango_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h5'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo urbango_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_h5_styles' );
}

if ( ! function_exists( 'urbango_edge_h6_styles' ) ) {
	function urbango_edge_h6_styles() {
		$margin_top    = urbango_edge_options()->getOptionValue( 'h6_margin_top' );
		$margin_bottom = urbango_edge_options()->getOptionValue( 'h6_margin_bottom' );
		
		$item_styles = urbango_edge_get_typography_styles( 'h6' );
		
		$other_item_selector = array(
			'.edgtf-comment-form label',
			'.edgtf-blog-single-navigation .edgtf-blog-single-nav-title',
			'.edgtf-countdown .countdown-row .countdown-section .countdown-period',
			'.edgtf-woocommerce-page table.cart thead th',
			'.edgtf-woocommerce-page .cart-collaterals table th',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-1 label:not(.checkbox)',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-2 label:not(.checkbox)',
			'.edgtf-woocommerce-page .woocommerce-checkout table thead th',
			'.edgtf-woocommerce-page.woocommerce-order-received .woocommerce table.shop_table thead th',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce table.shop_table thead th',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce form.edit-account label',
			'.edgtf-woocommerce-page.woocommerce-account .vc_row .woocommerce form.login p label:not(.inline)',
			'.edgtf-woocommerce-page.woocommerce-account.woocommerce-edit-address .woocommerce form label',
			'.edgtf-woocommerce-page.edgtf-woocommerce-order-tracking .woocommerce > .track_order .form-row label',
			'.edgtf-membership-dashboard-nav-holder .edgtf-membership-dashboard-nav-opener > *:last-child',
			'.edgtf-membership-dashboard-content-holder .edgtf-dashboard-form label',
			'.edgtf-listing-profile-searches .edgtf-lp-ss-heading > *',
			'.edgtf-listing-profile-my-packages .edgtf-lp-pi-heading > *',
			'.edgtf-listing-profile-claimed-items .edgtf-lp-ci-heading > *',
			'.edgtf-listing-single-holder .edgtf-comment-holder .edgtf-rating-label'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo urbango_edge_dynamic_css( $other_item_selector, $item_styles );
		}
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = urbango_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = urbango_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'h6'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo urbango_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_h6_styles' );
}

if ( ! function_exists( 'urbango_edge_text_styles' ) ) {
	function urbango_edge_text_styles() {
		$margin_top    = urbango_edge_options()->getOptionValue( 'text_margin_top' );
		$margin_bottom = urbango_edge_options()->getOptionValue( 'text_margin_bottom' );
		
		$item_styles = urbango_edge_get_typography_styles( 'text' );
		
		if ( $margin_top !== '' ) {
			$item_styles['margin-top'] = urbango_edge_filter_px( $margin_top ) . 'px';
		}
		if ( $margin_bottom !== '' ) {
			$item_styles['margin-bottom'] = urbango_edge_filter_px( $margin_bottom ) . 'px';
		}
		
		$item_selector = array(
			'p'
		);
		
		if ( ! empty( $item_styles ) ) {
			echo urbango_edge_dynamic_css( $item_selector, $item_styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_text_styles' );
}

if ( ! function_exists( 'urbango_edge_link_styles' ) ) {
	function urbango_edge_link_styles() {
		$link_styles      = array();
		$link_color       = urbango_edge_options()->getOptionValue( 'link_color' );
		$link_font_style  = urbango_edge_options()->getOptionValue( 'link_fontstyle' );
		$link_font_weight = urbango_edge_options()->getOptionValue( 'link_fontweight' );
		$link_decoration  = urbango_edge_options()->getOptionValue( 'link_fontdecoration' );
		
		if ( ! empty( $link_color ) ) {
			$link_styles['color'] = $link_color;
		}
		if ( ! empty( $link_font_style ) ) {
			$link_styles['font-style'] = $link_font_style;
		}
		if ( ! empty( $link_font_weight ) ) {
			$link_styles['font-weight'] = $link_font_weight;
		}
		if ( ! empty( $link_decoration ) ) {
			$link_styles['text-decoration'] = $link_decoration;
		}
		
		$link_selector = array(
			'a',
			'p a'
		);
		
		if ( ! empty( $link_styles ) ) {
			echo urbango_edge_dynamic_css( $link_selector, $link_styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_link_styles' );
}

if ( ! function_exists( 'urbango_edge_link_hover_styles' ) ) {
	function urbango_edge_link_hover_styles() {
		$link_hover_styles     = array();
		$link_hover_color      = urbango_edge_options()->getOptionValue( 'link_hovercolor' );
		$link_hover_decoration = urbango_edge_options()->getOptionValue( 'link_hover_fontdecoration' );
		
		if ( ! empty( $link_hover_color ) ) {
			$link_hover_styles['color'] = $link_hover_color;
		}
		if ( ! empty( $link_hover_decoration ) ) {
			$link_hover_styles['text-decoration'] = $link_hover_decoration;
		}
		
		$link_hover_selector = array(
			'a:hover',
			'p a:hover'
		);
		
		if ( ! empty( $link_hover_styles ) ) {
			echo urbango_edge_dynamic_css( $link_hover_selector, $link_hover_styles );
		}
		
		$link_heading_hover_styles = array();
		
		if ( ! empty( $link_hover_color ) ) {
			$link_heading_hover_styles['color'] = $link_hover_color;
		}
		
		$link_heading_hover_selector = array(
			'h1 a:hover',
			'h2 a:hover',
			'h3 a:hover',
			'h4 a:hover',
			'h5 a:hover',
			'h6 a:hover'
		);
		
		if ( ! empty( $link_heading_hover_styles ) ) {
			echo urbango_edge_dynamic_css( $link_heading_hover_selector, $link_heading_hover_styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic', 'urbango_edge_link_hover_styles' );
}

if ( ! function_exists( 'urbango_edge_smooth_page_transition_styles' ) ) {
	function urbango_edge_smooth_page_transition_styles( $style ) {
		$id            = urbango_edge_get_page_id();
		$loader_style  = array();
		$current_style = '';
		
		$background_color = urbango_edge_get_meta_field_intersect( 'smooth_pt_bgnd_color', $id );
		if ( ! empty( $background_color ) ) {
			$loader_style['background-color'] = $background_color;
		}
		
		$loader_selector = array(
			'.edgtf-smooth-transition-loader'
		);
		
		if ( ! empty( $loader_style ) ) {
			$current_style .= urbango_edge_dynamic_css( $loader_selector, $loader_style );
		}
		
		$spinner_style = array();
		$spinner_color = urbango_edge_get_meta_field_intersect( 'smooth_pt_spinner_color', $id );
		if ( ! empty( $spinner_color ) ) {
			$spinner_style['background-color'] = $spinner_color;
		}
		
		$spinner_selectors = array(
			'.edgtf-st-loader .edgtf-rotate-circles > div',
			'.edgtf-st-loader .pulse',
			'.edgtf-st-loader .double_pulse .double-bounce1',
			'.edgtf-st-loader .double_pulse .double-bounce2',
			'.edgtf-st-loader .cube',
			'.edgtf-st-loader .rotating_cubes .cube1',
			'.edgtf-st-loader .rotating_cubes .cube2',
			'.edgtf-st-loader .stripes > div',
			'.edgtf-st-loader .wave > div',
			'.edgtf-st-loader .two_rotating_circles .dot1',
			'.edgtf-st-loader .two_rotating_circles .dot2',
			'.edgtf-st-loader .five_rotating_circles .container1 > div',
			'.edgtf-st-loader .five_rotating_circles .container2 > div',
			'.edgtf-st-loader .five_rotating_circles .container3 > div',
			'.edgtf-st-loader .atom .ball-1:before',
			'.edgtf-st-loader .atom .ball-2:before',
			'.edgtf-st-loader .atom .ball-3:before',
			'.edgtf-st-loader .atom .ball-4:before',
			'.edgtf-st-loader .clock .ball:before',
			'.edgtf-st-loader .mitosis .ball',
			'.edgtf-st-loader .lines .line1',
			'.edgtf-st-loader .lines .line2',
			'.edgtf-st-loader .lines .line3',
			'.edgtf-st-loader .lines .line4',
			'.edgtf-st-loader .fussion .ball',
			'.edgtf-st-loader .fussion .ball-1',
			'.edgtf-st-loader .fussion .ball-2',
			'.edgtf-st-loader .fussion .ball-3',
			'.edgtf-st-loader .fussion .ball-4',
			'.edgtf-st-loader .wave_circles .ball',
			'.edgtf-st-loader .pulse_circles .ball'
		);
		
		if ( ! empty( $spinner_style ) ) {
			$current_style .= urbango_edge_dynamic_css( $spinner_selectors, $spinner_style );
		}
		
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'urbango_edge_filter_add_page_custom_style', 'urbango_edge_smooth_page_transition_styles' );
}