<?php

if ( ! function_exists( 'urbango_edge_content_responsive_styles' ) ) {
	/**
	 * Generates content responsive custom styles
	 */
	function urbango_edge_content_responsive_styles() {
		$content_style = array();
		
		$padding_mobile = urbango_edge_options()->getOptionValue( 'content_padding_mobile' );
		if ( $padding_mobile !== '' ) {
			$content_style['padding'] = $padding_mobile;
		}
		
		$content_selector = array(
			'.edgtf-content .edgtf-content-inner > .edgtf-container > .edgtf-container-inner',
			'.edgtf-content .edgtf-content-inner > .edgtf-full-width > .edgtf-full-width-inner',
		);
		
		echo urbango_edge_dynamic_css( $content_selector, $content_style );
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_1024', 'urbango_edge_content_responsive_styles' );
}

if ( ! function_exists( 'urbango_edge_h1_responsive_styles3' ) ) {
	function urbango_edge_h1_responsive_styles3() {
		$selector = array(
			'h1'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h1_responsive', '_3' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_768_1024', 'urbango_edge_h1_responsive_styles3' );
}

if ( ! function_exists( 'urbango_edge_h2_responsive_styles3' ) ) {
	function urbango_edge_h2_responsive_styles3() {
		$selector = array(
			'h2'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h2_responsive', '_3' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_768_1024', 'urbango_edge_h2_responsive_styles3' );
}

if ( ! function_exists( 'urbango_edge_h3_responsive_styles3' ) ) {
	function urbango_edge_h3_responsive_styles3() {
		$selector = array(
			'h3',
			'.edgtf-woocommerce-page .cart_totals > h2',
			'.edgtf-woocommerce-page .cross-sells > h2',
			'.edgtf-woocommerce-page .cart-empty',
			'div.woocommerce > .single-product .related.products > h2',
			'div.woocommerce > .single-product .upsells.products > h2',
			'.edgtf-woo-single-page .related.products > h2',
			'.edgtf-woo-single-page .upsells.products > h2'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h3_responsive', '_3' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_768_1024', 'urbango_edge_h3_responsive_styles3' );
}

if ( ! function_exists( 'urbango_edge_h4_responsive_styles3' ) ) {
	function urbango_edge_h4_responsive_styles3() {
		$selector = array(
			'h4'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h4_responsive', '_3' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_768_1024', 'urbango_edge_h4_responsive_styles3' );
}

if ( ! function_exists( 'urbango_edge_h5_responsive_styles3' ) ) {
	function urbango_edge_h5_responsive_styles3() {
		$selector = array(
			'h5',
			'.edgtf-blog-pagination ul li a',
			'.edgtf-bl-standard-pagination ul li a',
			'.edgtf-tabs .edgtf-tabs-nav li a',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-1 h3',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-2 h3',
			'.edgtf-woocommerce-page .woocommerce-checkout h3#order_review_heading',
			'.edgtf-woocommerce-page.woocommerce-order-received .woocommerce h2',
			'.edgtf-woocommerce-page.woocommerce-view-order .woocommerce h2',
			'.woocommerce-pagination ul li a',
			'.woocommerce-pagination ul li span',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce-MyAccount-navigation ul li a',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce .col2-set.addresses h3',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce form.edit-account fieldset > legend',
			'.edgtf-woocommerce-page.woocommerce-account .vc_row .woocommerce > h2',
			'.edgtf-woocommerce-page.woocommerce-account.woocommerce-edit-address .woocommerce form h3',
			'div.woocommerce > .single-product .woocommerce-tabs ul.tabs > li a',
			'div.woocommerce > .single-product .woocommerce-tabs #reviews h2',
			'div.woocommerce > .single-product .woocommerce-tabs #reviews .comment-respond .comment-reply-title',
			'.edgtf-woo-single-page .woocommerce-tabs ul.tabs > li a',
			'.edgtf-woo-single-page .woocommerce-tabs #reviews h2',
			'.edgtf-woo-single-page .woocommerce-tabs #reviews .comment-respond .comment-reply-title',
			'.edgtf-listing-profile-page .edgtf-profile-info p > span',
			'.edgtf-category-list-holder .edgtf-cl-items-count',
			'.edgtf-location-banner-holder .edgtf-lb-items-count',
			'.edgtf-location-list-holder .edgtf-ll-items-count',
			'.edgtf-membership-main-wrapper .edgtf-login-register-content.edgtf-user-not-logged-in.ui-tabs ul li a'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h5_responsive', '_3' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_768_1024', 'urbango_edge_h5_responsive_styles3' );
}

if ( ! function_exists( 'urbango_edge_h6_responsive_styles3' ) ) {
	function urbango_edge_h6_responsive_styles3() {
		$selector = array(
			'h6',
			'.edgtf-comment-form label',
			'.edgtf-blog-single-navigation .edgtf-blog-single-nav-title',
			'.edgtf-countdown .countdown-row .countdown-section .countdown-period',
			'.edgtf-woocommerce-page table.cart thead th',
			'.edgtf-woocommerce-page .cart-collaterals table th',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-1 label:not(.checkbox)',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-2 label:not(.checkbox)',
			'.edgtf-woocommerce-page .woocommerce-checkout table thead th',
			'.edgtf-woocommerce-page.woocommerce-order-received .woocommerce table.shop_table thead th',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce table.shop_table thead th',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce form.edit-account label',
			'.edgtf-woocommerce-page.woocommerce-account .vc_row .woocommerce form.login p label:not(.inline)',
			'.edgtf-woocommerce-page.woocommerce-account.woocommerce-edit-address .woocommerce form label',
			'.edgtf-woocommerce-page.edgtf-woocommerce-order-tracking .woocommerce > .track_order .form-row label',
			'.edgtf-membership-dashboard-nav-holder .edgtf-membership-dashboard-nav-opener > *:last-child',
			'.edgtf-membership-dashboard-content-holder .edgtf-dashboard-form label',
			'.edgtf-listing-profile-searches .edgtf-lp-ss-heading > *',
			'.edgtf-listing-profile-my-packages .edgtf-lp-pi-heading > *',
			'.edgtf-listing-profile-claimed-items .edgtf-lp-ci-heading > *',
			'.edgtf-listing-single-holder .edgtf-comment-holder .edgtf-rating-label'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h6_responsive', '_3' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_768_1024', 'urbango_edge_h6_responsive_styles3' );
}

if ( ! function_exists( 'urbango_edge_h1_responsive_styles' ) ) {
	function urbango_edge_h1_responsive_styles() {
		$selector = array(
			'h1'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h1_responsive' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680_768', 'urbango_edge_h1_responsive_styles' );
}

if ( ! function_exists( 'urbango_edge_h2_responsive_styles' ) ) {
	function urbango_edge_h2_responsive_styles() {
		$selector = array(
			'h2'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h2_responsive' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680_768', 'urbango_edge_h2_responsive_styles' );
}

if ( ! function_exists( 'urbango_edge_h3_responsive_styles' ) ) {
	function urbango_edge_h3_responsive_styles() {
		$selector = array(
			'h3',
			'.edgtf-woocommerce-page .cart_totals > h2',
			'.edgtf-woocommerce-page .cross-sells > h2',
			'.edgtf-woocommerce-page .cart-empty',
			'div.woocommerce > .single-product .related.products > h2',
			'div.woocommerce > .single-product .upsells.products > h2',
			'.edgtf-woo-single-page .related.products > h2',
			'.edgtf-woo-single-page .upsells.products > h2'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h3_responsive' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680_768', 'urbango_edge_h3_responsive_styles' );
}

if ( ! function_exists( 'urbango_edge_h4_responsive_styles' ) ) {
	function urbango_edge_h4_responsive_styles() {
		$selector = array(
			'h4'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h4_responsive' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680_768', 'urbango_edge_h4_responsive_styles' );
}

if ( ! function_exists( 'urbango_edge_h5_responsive_styles' ) ) {
	function urbango_edge_h5_responsive_styles() {
		$selector = array(
			'h5',
			'.edgtf-blog-pagination ul li a',
			'.edgtf-bl-standard-pagination ul li a',
			'.edgtf-tabs .edgtf-tabs-nav li a',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-1 h3',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-2 h3',
			'.edgtf-woocommerce-page .woocommerce-checkout h3#order_review_heading',
			'.edgtf-woocommerce-page.woocommerce-order-received .woocommerce h2',
			'.edgtf-woocommerce-page.woocommerce-view-order .woocommerce h2',
			'.woocommerce-pagination ul li a',
			'.woocommerce-pagination ul li span',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce-MyAccount-navigation ul li a',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce .col2-set.addresses h3',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce form.edit-account fieldset > legend',
			'.edgtf-woocommerce-page.woocommerce-account .vc_row .woocommerce > h2',
			'.edgtf-woocommerce-page.woocommerce-account.woocommerce-edit-address .woocommerce form h3',
			'div.woocommerce > .single-product .woocommerce-tabs ul.tabs > li a',
			'div.woocommerce > .single-product .woocommerce-tabs #reviews h2',
			'div.woocommerce > .single-product .woocommerce-tabs #reviews .comment-respond .comment-reply-title',
			'.edgtf-woo-single-page .woocommerce-tabs ul.tabs > li a',
			'.edgtf-woo-single-page .woocommerce-tabs #reviews h2',
			'.edgtf-woo-single-page .woocommerce-tabs #reviews .comment-respond .comment-reply-title',
			'.edgtf-listing-profile-page .edgtf-profile-info p > span',
			'.edgtf-category-list-holder .edgtf-cl-items-count',
			'.edgtf-location-banner-holder .edgtf-lb-items-count',
			'.edgtf-location-list-holder .edgtf-ll-items-count',
			'.edgtf-membership-main-wrapper .edgtf-login-register-content.edgtf-user-not-logged-in.ui-tabs ul li a'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h5_responsive' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680_768', 'urbango_edge_h5_responsive_styles' );
}

if ( ! function_exists( 'urbango_edge_h6_responsive_styles' ) ) {
	function urbango_edge_h6_responsive_styles() {
		$selector = array(
			'h6',
			'.edgtf-comment-form label',
			'.edgtf-blog-single-navigation .edgtf-blog-single-nav-title',
			'.edgtf-countdown .countdown-row .countdown-section .countdown-period',
			'.edgtf-woocommerce-page table.cart thead th',
			'.edgtf-woocommerce-page .cart-collaterals table th',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-1 label:not(.checkbox)',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-2 label:not(.checkbox)',
			'.edgtf-woocommerce-page .woocommerce-checkout table thead th',
			'.edgtf-woocommerce-page.woocommerce-order-received .woocommerce table.shop_table thead th',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce table.shop_table thead th',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce form.edit-account label',
			'.edgtf-woocommerce-page.woocommerce-account .vc_row .woocommerce form.login p label:not(.inline)',
			'.edgtf-woocommerce-page.woocommerce-account.woocommerce-edit-address .woocommerce form label',
			'.edgtf-woocommerce-page.edgtf-woocommerce-order-tracking .woocommerce > .track_order .form-row label',
			'.edgtf-membership-dashboard-nav-holder .edgtf-membership-dashboard-nav-opener > *:last-child',
			'.edgtf-membership-dashboard-content-holder .edgtf-dashboard-form label',
			'.edgtf-listing-profile-searches .edgtf-lp-ss-heading > *',
			'.edgtf-listing-profile-my-packages .edgtf-lp-pi-heading > *',
			'.edgtf-listing-profile-claimed-items .edgtf-lp-ci-heading > *',
			'.edgtf-listing-single-holder .edgtf-comment-holder .edgtf-rating-label'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h6_responsive' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680_768', 'urbango_edge_h6_responsive_styles' );
}

if ( ! function_exists( 'urbango_edge_text_responsive_styles' ) ) {
	function urbango_edge_text_responsive_styles() {
		$selector = array(
			'body',
			'p'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'text', '_res1' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680_768', 'urbango_edge_text_responsive_styles' );
}

if ( ! function_exists( 'urbango_edge_h1_responsive_styles2' ) ) {
	function urbango_edge_h1_responsive_styles2() {
		$selector = array(
			'h1'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h1_responsive', '_2' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680', 'urbango_edge_h1_responsive_styles2' );
}

if ( ! function_exists( 'urbango_edge_h2_responsive_styles2' ) ) {
	function urbango_edge_h2_responsive_styles2() {
		$selector = array(
			'h2'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h2_responsive', '_2' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680', 'urbango_edge_h2_responsive_styles2' );
}

if ( ! function_exists( 'urbango_edge_h3_responsive_styles2' ) ) {
	function urbango_edge_h3_responsive_styles2() {
		$selector = array(
			'h3',
			'.edgtf-woocommerce-page .cart_totals > h2',
			'.edgtf-woocommerce-page .cross-sells > h2',
			'.edgtf-woocommerce-page .cart-empty',
			'div.woocommerce > .single-product .related.products > h2',
			'div.woocommerce > .single-product .upsells.products > h2',
			'.edgtf-woo-single-page .related.products > h2',
			'.edgtf-woo-single-page .upsells.products > h2'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h3_responsive', '_2' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680', 'urbango_edge_h3_responsive_styles2' );
}

if ( ! function_exists( 'urbango_edge_h4_responsive_styles2' ) ) {
	function urbango_edge_h4_responsive_styles2() {
		$selector = array(
			'h4'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h4_responsive', '_2' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680', 'urbango_edge_h4_responsive_styles2' );
}

if ( ! function_exists( 'urbango_edge_h5_responsive_styles2' ) ) {
	function urbango_edge_h5_responsive_styles2() {
		$selector = array(
			'h5',
			'.edgtf-blog-pagination ul li a',
			'.edgtf-bl-standard-pagination ul li a',
			'.edgtf-tabs .edgtf-tabs-nav li a',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-1 h3',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-2 h3',
			'.edgtf-woocommerce-page .woocommerce-checkout h3#order_review_heading',
			'.edgtf-woocommerce-page.woocommerce-order-received .woocommerce h2',
			'.edgtf-woocommerce-page.woocommerce-view-order .woocommerce h2',
			'.woocommerce-pagination ul li a',
			'.woocommerce-pagination ul li span',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce-MyAccount-navigation ul li a',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce .col2-set.addresses h3',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce form.edit-account fieldset > legend',
			'.edgtf-woocommerce-page.woocommerce-account .vc_row .woocommerce > h2',
			'.edgtf-woocommerce-page.woocommerce-account.woocommerce-edit-address .woocommerce form h3',
			'div.woocommerce > .single-product .woocommerce-tabs ul.tabs > li a',
			'div.woocommerce > .single-product .woocommerce-tabs #reviews h2',
			'div.woocommerce > .single-product .woocommerce-tabs #reviews .comment-respond .comment-reply-title',
			'.edgtf-woo-single-page .woocommerce-tabs ul.tabs > li a',
			'.edgtf-woo-single-page .woocommerce-tabs #reviews h2',
			'.edgtf-woo-single-page .woocommerce-tabs #reviews .comment-respond .comment-reply-title',
			'.edgtf-listing-profile-page .edgtf-profile-info p > span',
			'.edgtf-category-list-holder .edgtf-cl-items-count',
			'.edgtf-location-banner-holder .edgtf-lb-items-count',
			'.edgtf-location-list-holder .edgtf-ll-items-count',
			'.edgtf-membership-main-wrapper .edgtf-login-register-content.edgtf-user-not-logged-in.ui-tabs ul li a'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h5_responsive', '_2' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680', 'urbango_edge_h5_responsive_styles2' );
}

if ( ! function_exists( 'urbango_edge_h6_responsive_styles2' ) ) {
	function urbango_edge_h6_responsive_styles2() {
		$selector = array(
			'h6',
			'.edgtf-comment-form label',
			'.edgtf-blog-single-navigation .edgtf-blog-single-nav-title',
			'.edgtf-countdown .countdown-row .countdown-section .countdown-period',
			'.edgtf-woocommerce-page table.cart thead th',
			'.edgtf-woocommerce-page .cart-collaterals table th',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-1 label:not(.checkbox)',
			'.edgtf-woocommerce-page .woocommerce-checkout .col-2 label:not(.checkbox)',
			'.edgtf-woocommerce-page .woocommerce-checkout table thead th',
			'.edgtf-woocommerce-page.woocommerce-order-received .woocommerce table.shop_table thead th',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce table.shop_table thead th',
			'.edgtf-woocommerce-page.woocommerce-account .woocommerce form.edit-account label',
			'.edgtf-woocommerce-page.woocommerce-account .vc_row .woocommerce form.login p label:not(.inline)',
			'.edgtf-woocommerce-page.woocommerce-account.woocommerce-edit-address .woocommerce form label',
			'.edgtf-woocommerce-page.edgtf-woocommerce-order-tracking .woocommerce > .track_order .form-row label',
			'.edgtf-membership-dashboard-nav-holder .edgtf-membership-dashboard-nav-opener > *:last-child',
			'.edgtf-membership-dashboard-content-holder .edgtf-dashboard-form label',
			'.edgtf-listing-profile-searches .edgtf-lp-ss-heading > *',
			'.edgtf-listing-profile-my-packages .edgtf-lp-pi-heading > *',
			'.edgtf-listing-profile-claimed-items .edgtf-lp-ci-heading > *',
			'.edgtf-listing-single-holder .edgtf-comment-holder .edgtf-rating-label'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'h6_responsive', '_2' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680', 'urbango_edge_h6_responsive_styles2' );
}

if ( ! function_exists( 'urbango_edge_text_responsive_styles2' ) ) {
	function urbango_edge_text_responsive_styles2() {
		$selector = array(
			'body',
			'p'
		);
		
		$styles = urbango_edge_get_responsive_typography_styles( 'text', '_res2' );
		
		if ( ! empty( $styles ) ) {
			echo urbango_edge_dynamic_css( $selector, $styles );
		}
	}
	
	add_action( 'urbango_edge_action_style_dynamic_responsive_680', 'urbango_edge_text_responsive_styles2' );
}