<?php get_header(); ?>
				<div class="edgtf-page-not-found">
					<?php
					$edgtf_title_image_404 = urbango_edge_options()->getOptionValue( '404_page_title_image' );
					$edgtf_title_image     = ! empty( $edgtf_title_image_404 ) ? $edgtf_title_image_404 : EDGE_ASSETS_ROOT . '/img/404-title-image.png';
					$edgtf_title_404       = urbango_edge_options()->getOptionValue( '404_title' );
					$edgtf_text_404        = urbango_edge_options()->getOptionValue( '404_text' );
					$edgtf_button_label    = urbango_edge_options()->getOptionValue( '404_back_to_home' );
					$edgtf_button_style    = urbango_edge_options()->getOptionValue( '404_button_style' );
					?>
					<div class="edgtf-404-content">
						<div class="edgtf-404-title-image">
							<img src="<?php echo esc_url( $edgtf_title_image ); ?>" alt="<?php esc_attr_e( '404 Title Image', 'urbango' ); ?>" />
						</div>
						<div class="edgtf-404-content-info">
							<h2 class="edgtf-404-title">
								<?php if ( ! empty( $edgtf_title_404 ) ) {
									echo esc_html( $edgtf_title_404 );
								} else {
									esc_html_e( 'Error page', 'urbango' );
								} ?>
							</h2>
							
							<p class="edgtf-404-text">
								<?php if ( ! empty( $edgtf_text_404 ) ) {
									echo esc_html( $edgtf_text_404 );
								} else {
									esc_html_e( 'Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'urbango' );
								} ?>
							</p>
							
							<?php
							$button_params = array(
								'link' => esc_url( home_url( '/' ) ),
								'text' => ! empty( $edgtf_button_label ) ? $edgtf_button_label : esc_html__( 'Back to home', 'urbango' )
							);
							
							if ( $edgtf_button_style == 'light-style' ) {
								$button_params['custom_class'] = 'edgtf-btn-light-style';
							}
							
							echo urbango_edge_return_button_html( $button_params );
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php get_footer(); ?>
</body>
</html>