<?php
/**
 * Plugin Name: UrbanGo Membership
 * Description: Plugin that adds social login and user dashboard page
 * Author: Edge Themes
 * Version: 1.1
 */

require_once 'load.php';

if ( ! function_exists( 'urbango_membership_text_domain' ) ) {
	/**
	 * Loads plugin text domain so it can be used in translation
	 */
	function urbango_membership_text_domain() {
		load_plugin_textdomain( 'urbango-membership', false, URBANGO_MEMBERSHIP_REL_PATH . '/languages' );
	}
	
	add_action( 'plugins_loaded', 'urbango_membership_text_domain' );
}

if ( ! function_exists( 'urbango_membership_scripts' ) ) {
	/**
	 * Loads plugin scripts
	 */
	function urbango_membership_scripts() {
		wp_enqueue_style( 'urbango-membership-style', plugins_url( URBANGO_MEMBERSHIP_REL_PATH . '/assets/css/membership.min.css' ) );
		if ( function_exists( 'urbango_edge_is_responsive_on' ) && urbango_edge_is_responsive_on() ) {
			wp_enqueue_style( 'urbango-membership-responsive-style', plugins_url( URBANGO_MEMBERSHIP_REL_PATH . '/assets/css/membership-responsive.min.css' ) );
		}
		
		//underscore for facebook login
		//tabs for login widget
		$array_deps = array(
			'underscore',
			'jquery-ui-tabs'
		);
		
		if ( urbango_membership_theme_installed() ) {
			$array_deps[] = 'urbango-edge-modules';
		}
		
		wp_enqueue_script( 'urbango-membership-script', plugins_url( URBANGO_MEMBERSHIP_REL_PATH . '/assets/js/membership.min.js' ), $array_deps, false, true );
	}
	
	add_action( 'wp_enqueue_scripts', 'urbango_membership_scripts' );
}

if ( ! function_exists( 'urbango_membership_style_dynamics_deps' ) ) {
	function urbango_membership_style_dynamics_deps( $deps ) {
		$style_dynamic_deps_array   = array();
		$style_dynamic_deps_array[] = 'urbango-membership-style';
		
		if ( function_exists( 'urbango_edge_is_responsive_on' ) && urbango_edge_is_responsive_on() ) {
			$style_dynamic_deps_array[] = 'urbango-membership-responsive-style';
		}
		
		return array_merge( $deps, $style_dynamic_deps_array );
	}
	
	add_filter( 'urbango_edge_filter_style_dynamic_deps', 'urbango_membership_style_dynamics_deps' );
}

if ( ! function_exists( 'urbango_membership_render_login_form' ) ) {
	function urbango_membership_render_login_form() {
		
		if ( ! is_user_logged_in() ) {
			//Render modal with login and register forms
			echo urbango_membership_get_module_template_part( 'widgets', 'login-widget', 'login-modal-template' );
		}
	}
	
	add_action( 'wp_footer', 'urbango_membership_render_login_form' );
}
