<?php

class UrbanGoMembershipLoginRegister extends WP_Widget {

	public function __construct() {
		parent::__construct(
			'edgtf_login_register_widget',
			esc_html__( 'UrbanGo Login Widget', 'urbango-membership' ),
			array( 'description' => esc_html__( 'Login and register membership widget', 'urbango-membership' ) )
		);
	}
	
	public function widget( $args, $instance ) {
		$additional_class = is_user_logged_in() ? 'edgtf-user-logged-in' : 'edgtf-user-not-logged-in';
		
		echo '<div class="widget edgtf-login-register-widget ' . esc_attr( $additional_class ) . '">';
        if ( ! is_user_logged_in() ) {
            echo urbango_membership_get_module_template_part( 'widgets', 'login-widget', 'login-widget-template', 'logged-out' );
        } else {
            echo urbango_membership_get_module_template_part( 'widgets', 'login-widget', 'login-widget-template', 'logged-in' );
        }
		echo '</div>';
	}
}

if ( ! function_exists( 'urbango_membership_login_widget_load' ) ) {
	function urbango_membership_login_widget_load() {
		register_widget( 'UrbanGoMembershipLoginRegister' );
	}
	
	add_action( 'widgets_init', 'urbango_membership_login_widget_load' );
}

