<div class="edgtf-social-login-holder">
    <form method="post" class="edgtf-login-form">
        <?php
        $redirect = '';
        if ( isset( $_GET['redirect_uri'] ) ) {
            $redirect = $_GET['redirect_uri'];
        } ?>
        <fieldset>
            <div>
                <input type="text" name="user_login_name" id="user_login_name" placeholder="<?php esc_attr_e( 'User Name', 'urbango-membership' ) ?>" value="" required pattern=".{3,}" title="<?php esc_attr_e( 'Three or more characters', 'urbango-membership' ); ?>"/>
            </div>
            <div>
                <input type="password" name="user_login_password" id="user_login_password" placeholder="<?php esc_attr_e( 'Password', 'urbango-membership' ) ?>" value="" required/>
            </div>
            <div class="edgtf-remember-holder clearfix">
                <span class="edgtf-login-remember">
                    <input name="rememberme" value="forever" id="rememberme" type="checkbox"/>
                    <label for="rememberme" class="edgtf-checbox-label"><?php esc_html_e( 'Keep me sign in', 'urbango-membership' ) ?></label>
                </span>
                <a href="<?php echo wp_lostpassword_url(); ?>" class="edgtf-login-action-btn" data-el="#edgtf-reset-pass-content" data-title="<?php esc_attr_e( 'Forgot Password?', 'urbango-membership' ); ?>"><?php esc_html_e( 'Lost Your password?', 'urbango-membership' ); ?></a>
            </div>
            <div class="edgtf-wp-section-button edgtf-login-button-holder">
               <?php if ( urbango_membership_theme_installed() ) {
	               echo urbango_edge_get_button_html( array(
		               'html_type' => 'button',
		               'text'      => esc_html__( 'Login', 'urbango-membership' ),
		               'type'      => 'solid'
	               ) );
               } else {
	               echo '<button type="submit">' . esc_html__( 'Login', 'urbango-membership' ) . '</button>';
               }
              
               wp_nonce_field( 'edgtf-ajax-login-nonce', 'edgtf-login-security' );
               ?>
            </div>
            <input type="hidden" name="redirect" id="redirect" value="<?php echo esc_url( $redirect ); ?>">
        </fieldset>
    </form>
	<?php if ( ! is_page_template( 'user-dashboard.php' ) ) { ?>
		<p class="edgtf-wp-section-notice">
			<span><?php esc_html_e( 'Not a member?', 'urbango-membership' ); ?></span>
			<a class="edgtf-wp-register-button" href="#"><?php esc_html_e( 'Register here', 'urbango-membership' ); ?></a>
		</p>
	<?php } ?>
    <?php if ( urbango_membership_theme_installed() ) {
	    //if social login enabled add social networks login
	    $social_login_enabled = urbango_edge_options()->getOptionValue( 'enable_social_login' ) == 'yes';
	    
	    if ( $social_login_enabled ) { ?>
		    <div class="edgtf-login-form-social-login">
			    <p class="edgtf-login-social-title"><?php esc_html_e( 'For faster login connect with your Social Network', 'urbango-membership' ); ?></p>
			    <div class="edgtf-login-social-networks">
				    <?php do_action( 'urbango_membership_social_network_login' ); ?>
			    </div>
		    </div>
	    <?php }
    }
    do_action( 'urbango_membership_action_login_ajax_response' );
    ?>
</div>