(function($) {
    'use strict';

    var membershipFavorites = {};
    edgtf.modules.membershipFavorites = membershipFavorites;

    membershipFavorites.edgtfOnDocumentReady = edgtfOnDocumentReady;

    $(document).ready(edgtfOnDocumentReady);
    
    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function edgtfOnDocumentReady() {
        edgtfMembershipAddToWishlist();
        edgtfMembershipAddToWishlistTriggerEvent();
    }

    function edgtfMembershipAddToWishlist(){
        $('.edgtf-membership-item-favorites').on('click',function(e) {
            e.preventDefault();
            var item = $(this),
                itemID;

            if(typeof item.data('item-id') !== 'undefined') {
                itemID = item.data('item-id');
            }

            edgtfMembershipWhishlistAdding(item, itemID);
        });
    }

    function edgtfMembershipWhishlistAdding(item, itemID){
        var ajaxData = {
            action: 'urbango_membership_add_item_to_favorites',
            item_id : itemID
        };

        $.ajax({
            type: 'POST',
            data: ajaxData,
            url: edgtfGlobalVars.vars.edgtfAjaxUrl,
            success: function (data) {
                var response = JSON.parse(data);
                
                if(response.status === 'success'){
                    if(!item.hasClass('edgtf-icon-only')) {
                        item.find('span').text(response.data.message);
                    }
                    item.find('.edgtf-favorites-icon').removeClass('fa-heart fa-heart-o').addClass(response.data.icon);
                }
            }
        });

        return false;
    }

    function edgtfMembershipAddToWishlistTriggerEvent() {
        $( document.body ).on( 'urbango_membership_favorites_trigger', function() {
            edgtfMembershipAddToWishlist();
        });
    }

})(jQuery);