<?php
/**
 * Plugin functions
 */

if ( ! function_exists( 'urbango_membership_version_class' ) ) {
	/**
	 * Adds plugin version class to body
	 *
	 * @param $classes
	 *
	 * @return array
	 */
	function urbango_membership_version_class( $classes ) {
		$classes[] = 'edgtf-social-login-' . URBANGO_MEMBERSHIP_VERSION;

		return $classes;
	}

	add_filter( 'body_class', 'urbango_membership_version_class' );
}

if ( ! function_exists( 'urbango_membership_theme_installed' ) ) {
	/**
	 * Checks whether theme is installed or not
	 * @return bool
	 */
	function urbango_membership_theme_installed() {
		return defined( 'EDGE_ROOT' );
	}
}

if ( ! function_exists( 'urbango_membership_get_module_template_part' ) ) {
	/**
	 * Loads Shortcode template part.
	 *
	 * @param        $module
	 * @param        $submodule
	 * @param        $template
	 * @param string $slug
	 * @param array $params
	 *
	 * @return string
	 * @see urbango_edge_get_template_part()
	 */
	function urbango_membership_get_module_template_part( $module, $submodule, $template, $slug = '', $params = array() ) {
		$available_characters = '/[^A-Za-z0-9\_\-\/]/';

		if ( is_scalar( $module ) ) {
			$module = preg_replace( $available_characters, '', $module );
		} else {
			$module = '';
		}

		if ( is_scalar( $template ) ) {
			$template = preg_replace( $available_characters, '', $template );
		} else {
			$template = '';
		}

		if ( is_scalar( $slug ) ) {
			$slug = preg_replace( $available_characters, '', $slug );
		} else {
			$slug = '';
		}

		if ( is_scalar( $submodule ) ) {
			$submodule = preg_replace( $available_characters, '', $submodule );
		} else {
			$submodule = '';
		}

		//HTML Content from template
		$html          = '';
		$template_path = URBANGO_MEMBERSHIP_ABS_PATH . '/modules/' . $module . '/' . $submodule . '/templates';

		$temp = $template_path . '/' . $template;
		if ( is_array( $params ) && count( $params ) ) {
			extract( $params, EXTR_SKIP ); // @codingStandardsIgnoreLine
		}

		$template = '';

		if ( ! empty( $temp ) ) {
			if ( ! empty( $slug ) ) {
				$template = "{$temp}-{$slug}.php";

				if ( ! file_exists( $template ) ) {
					$template = $temp . '.php';
				}
			} else {
				$template = $temp . '.php';
			}
		}

		if ( $template ) {
			ob_start();
			include( $template );
			$html = ob_get_clean();
		}

		return $html;
	}
}

if ( ! function_exists( 'urbango_membership_ajax_response' ) ) {
	/**
	 * Ajax response for login and register forms
	 *
	 * @param $status
	 * @param string $message
	 * @param string $redirect
	 * @param null $data
	 */
	function urbango_membership_ajax_response( $status, $message = '', $redirect = '', $data = null ) {
		$response = array(
			'status'   => $status,
			'message'  => $message,
			'redirect' => $redirect,
			'data'     => $data
		);

		$response = json_encode( $response );

		exit( $response );
	}
}

if ( ! function_exists( 'urbango_membership_ajax_response_message_holder' ) ) {
	/**
	 * Template for ajax response
	 */
	function urbango_membership_ajax_response_message_holder() {

		$html = '<div class="edgtf-membership-response-holder clearfix"></div>';
		$html .= '<script type="text/template" class="edgtf-membership-response-template">
					<div class="edgtf-membership-response <%= messageClass %> ">
						<div class="edgtf-membership-response-message">
							<p><%= message %></p>
						</div>
					</div>
				</script>';

		if ( function_exists( 'urbango_edge_get_module_part' ) ) {
			echo urbango_edge_get_module_part( $html );
		}
	}

	add_action( 'urbango_membership_action_login_ajax_response', 'urbango_membership_ajax_response_message_holder' );

}

if ( ! function_exists( 'urbango_membership_execute_shortcode' ) ) {
	/**
	 * @param $shortcode_tag - shortcode base
	 * @param $atts - shortcode attributes
	 * @param null $content - shortcode content
	 *
	 * @return mixed|string
	 */
	function urbango_membership_execute_shortcode( $shortcode_tag, $atts, $content = null ) {
		global $shortcode_tags;

		if ( ! isset( $shortcode_tags[ $shortcode_tag ] ) ) {
			return;
		}

		if ( is_array( $shortcode_tags[ $shortcode_tag ] ) ) {
			$shortcode_array = $shortcode_tags[ $shortcode_tag ];

			return call_user_func( array(
				$shortcode_array[0],
				$shortcode_array[1]
			), $atts, $content, $shortcode_tag );
		}

		return call_user_func( $shortcode_tags[ $shortcode_tag ], $atts, $content, $shortcode_tag );
	}
}

if ( ! function_exists( 'urbango_membership_kses_img' ) ) {
	/**
	 * Function that does escaping of img html.
	 * It uses wp_kses function with predefined attributes array.
	 * Should be used for escaping img tags in html.
	 * Defines urbango_edge_kses_img_atts filter that can be used for changing allowed html attributes
	 *
	 * @param $content string string to escape
	 *
	 * @return string escaped output
	 * @see wp_kses()
	 *
	 */
	function urbango_membership_kses_img( $content ) {
		$img_atts = apply_filters( 'urbango_membership_filter_kses_img_atts', array(
			'src'    => true,
			'alt'    => true,
			'height' => true,
			'width'  => true,
			'class'  => true,
			'id'     => true,
			'title'  => true
		) );

		return wp_kses( $content, array(
			'img' => $img_atts
		) );
	}
}

if ( ! function_exists( 'urbango_membership_dashboard_menu_svg_icons' ) ) {
	function urbango_membership_dashboard_menu_svg_icons( $menu_item ) {
		$html = '<span class="edgtf-custom-svg-icon">';

		switch ( $menu_item ) {
			case 'account':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="40.726px" height="40.717px" viewBox="0 0 40.726 40.717" enable-background="new 0 0 40.726 40.717" xml:space="preserve"><g><path stroke-width="2" stroke-miterlimit="10" d="M39.476,20.359 c0,10.554-8.556,19.108-19.116,19.108c-10.555,0-19.11-8.555-19.11-19.108C1.25,9.805,9.805,1.25,20.36,1.25 C30.92,1.25,39.476,9.805,39.476,20.359z"/><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d=" M16.287,14.221c0,0,5.234,0.738,6.869-3.26c0,0,1.751,3.234,4.311,3.234"/><g><g><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M16.408,23.975c0.002,0.963,0,3.037,0,3.037s0.219,1.298-7.481,3.257"/></g><g><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M24.319,23.975c-0.003,0.963,0,3.037,0,3.037s-0.218,1.298,7.481,3.257"/><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M22.749,24.451c1.043-0.25,1.577-0.717,1.577-0.717c1.767-1.255,2.862-5.189,3.192-7.946c0.486-4.061-0.055-8.919-7.134-9.08 h-0.042c-7.078,0.161-7.62,5.019-7.132,9.08c0.329,2.756,1.425,6.691,3.191,7.946c0,0,0.534,0.467,1.577,0.717"/></g></g></g></svg>';
				break;

			case 'profile':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="33.75px" height="42.014px" viewBox="0 0 33.75 42.014" enable-background="new 0 0 33.75 42.014" xml:space="preserve"><g><g><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M12.171,9.668c0,0,6.04,0.852,7.926-3.761c0,0,2.021,3.732,4.974,3.732"/><g><g><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M12.31,20.923c0.003,1.111,0,3.504,0,3.504s0.253,1.498-8.632,3.758"/></g><g><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M21.439,20.923c-0.003,1.111,0,3.504,0,3.504s-0.252,1.498,8.632,3.758"/><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M19.627,21.473c1.204-0.289,1.819-0.828,1.819-0.828c2.039-1.448,3.303-5.988,3.684-9.168C25.691,6.791,25.066,1.186,16.898,1h-0.047C8.683,1.186,8.059,6.791,8.621,11.477c0.38,3.181,1.644,7.721,3.682,9.168c0,0,0.616,0.539,1.819,0.828"/></g></g></g><line stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="1" y1="32.514" x2="32.75" y2="32.514"/><line stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="1" y1="36.764" x2="32.75" y2="36.764"/><line stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="1" y1="41.014" x2="16.201" y2="41.014"/></g></svg>';
				break;

			case 'edit-profile':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="43.963px" height="41.984px" viewBox="0 0 43.963 41.984" enable-background="new 0 0 43.963 41.984" xml:space="preserve"><g><g><g><g><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M33.782,36.288l-8.227,4.696l1.038-9.556l8.832-14.079c0.489-0.776,1.764-0.862,2.836-0.193l3.45,2.166c1.071,0.672,1.55,1.858,1.061,2.635L33.782,36.288z"/><line stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" x1="33.481" y1="35.235" x2="27.398" y2="31.417"/><line stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" x1="27.963" y1="39.507" x2="25.981" y2="38.23"/></g><line stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" x1="30.627" y1="33.357" x2="35.627" y2="25.387"/></g><line stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" x1="33.691" y1="20.474" x2="40.713" y2="24.879"/></g><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M9.624,10.834c0,0,7.056,0.965,9.196-4.267c0,0,2.365,4.131,5.309,4.131"/><g><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M10.041,23.604c0.004,1.26,0,3.975,0,3.975s0.287,1.7-9.794,4.265"/></g><g><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M20.398,23.604c-0.004,1.26,0,3.975,0,3.975c-0.026-0.058,0.551,1.125,3.584,2.208"/><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M18.343,24.228c1.308-0.51,2.064-0.939,2.064-0.939c2.312-1.643,3.746-6.793,4.178-10.402C25.222,7.57,24.514,1.211,15.247,1h-0.055C5.926,1.211,5.218,7.57,5.854,12.887c0.432,3.608,1.867,8.759,4.178,10.402C10.032,23.289,12.907,26.346,18.343,24.228z"/></g></g></svg>';
				break;

			case 'my-wishlist':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="32.4px" height="43.978px" viewBox="0 0 32.4 43.978" enable-background="new 0 0 32.4 43.978" xml:space="preserve"><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M26.474,7.011h2.676 c1.155,0,2.1,0.945,2.1,2.1v31.617c0,1.154-0.945,2.1-2.1,2.1H3.25c-1.155,0-2.1-0.945-2.1-2.1V9.111c0-1.155,0.945-2.1,2.1-2.1 h2.574"/><path stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" d="M23.163,4.581h-3.508c-0.038-1.9-1.584-3.431-3.492-3.431c-1.91,0-3.455,1.53-3.493,3.431H9.164v5.341h14V4.581z"/><line stroke-width="2" stroke-miterlimit="10" x1="16.149" y1="17.819" x2="26.776" y2="17.819"/><line stroke-width="2" stroke-miterlimit="10" x1="16.149" y1="22.231" x2="26.776" y2="22.231"/><line stroke-width="2" stroke-miterlimit="10" x1="16.149" y1="29.738" x2="26.776" y2="29.738"/><line stroke-width="2" stroke-miterlimit="10" x1="16.149" y1="34.149" x2="26.776" y2="34.149"/><g><g><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M12.671,18.734c0.743-0.743,0.754-1.947,0.026-2.676c-0.729-0.728-1.933-0.716-2.676,0.027l-0.46,0.458l-0.457-0.458c-0.743-0.743-1.947-0.755-2.676-0.027c-0.728,0.729-0.716,1.933,0.027,2.676l3.107,3.104L12.671,18.734z"/></g></g><g><g><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M12.573,32.952c0.743-0.743,0.754-1.947,0.026-2.676c-0.728-0.729-1.932-0.716-2.676,0.027l-0.46,0.457l-0.457-0.457c-0.743-0.743-1.947-0.755-2.676-0.027s-0.716,1.933,0.027,2.676l3.107,3.104L12.573,32.952z"/></g></g></svg>';
				break;

			case 'my-listings':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="32.6px" height="44.178px" viewBox="0 0 32.6 44.178" enable-background="new 0 0 32.6 44.178" xml:space="preserve"><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M26.575,7.111h2.675c1.154,0,2.1,0.945,2.1,2.1v31.617c0,1.155-0.945,2.1-2.1,2.1H3.35c-1.155,0-2.1-0.944-2.1-2.1V9.211c0-1.155,0.944-2.1,2.1-2.1h2.575"/><path stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" d="M23.263,4.68h-3.507c-0.039-1.9-1.584-3.43-3.493-3.43s-3.455,1.53-3.493,3.43H9.264v5.342h13.999V4.68z"/><g><g><line stroke-width="2" stroke-miterlimit="10" x1="12.027" y1="23.626" x2="25.827" y2="23.626"/><line stroke-width="2" stroke-miterlimit="10" x1="12.027" y1="29.265" x2="25.827" y2="29.265"/><g><g><g><rect x="7.535" y="17.686" stroke-width="2" stroke-miterlimit="10" width="0.589" height="0.602"/></g><line stroke-width="2" stroke-miterlimit="10" x1="11.924" y1="17.986" x2="25.827" y2="17.986"/></g><g><rect x="7.535" y="23.324" stroke-width="2" stroke-miterlimit="10" width="0.603" height="0.603"/></g><g><rect x="7.535" y="28.964" stroke-width="2" stroke-miterlimit="10" width="0.603" height="0.602"/></g><g><rect x="7.535" y="34.603" stroke-width="2" stroke-miterlimit="10" width="0.603" height="0.603"/></g></g></g><line stroke-width="2" stroke-miterlimit="10" x1="12.027" y1="34.903" x2="25.827" y2="34.903"/></g></svg>';
				break;

			case 'saved-searches':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="37.557px" height="39.302px" viewBox="0 0 37.557 39.302" enable-background="new 0 0 37.557 39.302" xml:space="preserve"><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M20.554,36.966H3.25c-1.155,0-2.1-0.945-2.1-2.1V3.25c0-1.155,0.945-2.1,2.1-2.1h23.225"/><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M26.475,1.15h2.675c1.155,0,2.1,0.945,2.1,2.1v11.787"/><g><g><rect x="6.735" y="7.677" stroke-width="2" stroke-miterlimit="10" width="0.602" height="0.602"/></g><line stroke-width="2" stroke-miterlimit="10" x1="11.227" y1="7.978" x2="25.454" y2="7.978"/></g><g><rect x="6.735" y="13.316" stroke-width="2" stroke-miterlimit="10" width="0.602" height="0.602"/></g><line stroke-width="2" stroke-miterlimit="10" x1="11.227" y1="13.617" x2="21.954" y2="13.617"/><g><rect x="6.735" y="18.955" stroke-width="2" stroke-miterlimit="10" width="0.602" height="0.602"/></g><line stroke-width="2" stroke-miterlimit="10" x1="11.227" y1="19.256" x2="15.82" y2="19.256"/><g><rect x="6.735" y="24.594" stroke-width="2" stroke-miterlimit="10" width="0.602" height="0.603"/></g><g><rect x="6.735" y="30.042" stroke-width="2" stroke-miterlimit="10" width="0.602" height="0.602"/></g><circle stroke-width="2" stroke-miterlimit="10" cx="26.509" cy="26.26" r="9.102"/><path stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" d="M30.577,26.257c-0.029,1.841-1.202,3.395-2.83,3.998"/><line stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" x1="32.271" y1="33.311" x2="36.407" y2="38.152"/></svg>';
				break;

			case 'add-listing':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="41.144px" height="44.318px" viewBox="0 0 41.144 44.318" enable-background="new 0 0 41.144 44.318" xml:space="preserve"><g><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M20.404,42.678H3.1c-1.155,0-2.1-0.945-2.1-2.1V8.961c0-1.155,0.945-2.1,2.1-2.1h2.574"/><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M26.325,6.861H29c1.155,0,2.1,0.945,2.1,2.1v11.787"/><circle stroke-width="2" stroke-miterlimit="10" cx="30.46" cy="33.635" r="9.684"/><path stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" d="M23.013,4.43h-3.507C19.467,2.53,17.922,1,16.013,1c-1.909,0-3.455,1.53-3.493,3.43H9.014v5.342h14V4.43z"/><g><g><rect x="7.285" y="17.436" stroke-width="2" stroke-miterlimit="10" width="0.603" height="0.602"/></g><line stroke-width="2" stroke-miterlimit="10" x1="11.777" y1="17.736" x2="26.004" y2="17.736"/></g><g><rect x="7.285" y="23.074" stroke-width="2" stroke-miterlimit="10" width="0.603" height="0.603"/></g><line stroke-width="2" stroke-miterlimit="10" x1="11.777" y1="23.376" x2="22.504" y2="23.376"/><line stroke-width="2" stroke-miterlimit="10" x1="25.097" y1="33.635" x2="35.824" y2="33.635"/><line stroke-width="2" stroke-miterlimit="10" x1="30.46" y1="38.998" x2="30.46" y2="28.271"/><g><g><rect x="7.285" y="28.714" stroke-width="2" stroke-miterlimit="10" width="0.603" height="0.602"/></g><line stroke-width="2" stroke-miterlimit="10" x1="11.777" y1="29.015" x2="18.225" y2="29.015"/></g><g><g><rect x="7.285" y="34.353" stroke-width="2" stroke-miterlimit="10" width="0.603" height="0.602"/></g><line stroke-width="2" stroke-miterlimit="10" x1="11.777" y1="34.654" x2="17.257" y2="34.654"/></g></g></svg>';
				break;

			case 'my-packages':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="42.201px" height="38.23px" viewBox="0 0 42.201 38.23" enable-background="new 0 0 42.201 38.23" xml:space="preserve"><g><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M14.363,6.142V3.271c0-1.175,0.944-2.12,2.1-2.12h9.275c1.154,0,2.1,0.945,2.1,2.12v2.871"/><path stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" d="M41.051,13.63c0,5.17-7.875,8.704-17.5,8.704h-4.9c-9.625,0-17.5-3.534-17.5-8.704V9.255h39.9V13.63z"/><polyline stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="41.051,21.416 41.051,37.08 1.15,37.08 1.15,21.416"/><line stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="18.505" y1="17.167" x2="23.696" y2="17.167"/></g></svg>';
				break;

			case 'reported-items':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="38.366px" height="38.116px" viewBox="0 0 38.366 38.116" enable-background="new 0 0 38.366 38.116" xml:space="preserve"><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M20.554,36.966H3.25c-1.155,0-2.1-0.945-2.1-2.1V3.25c0-1.155,0.945-2.1,2.1-2.1h23.225"/><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M26.475,1.15h2.675c1.155,0,2.1,0.945,2.1,2.1v11.787"/><line stroke-width="2" stroke-miterlimit="10" x1="5.685" y1="6.617" x2="25.037" y2="6.617"/><line stroke-width="2" stroke-miterlimit="10" x1="5.685" y1="12.042" x2="19.845" y2="12.042"/><line stroke-width="2" stroke-miterlimit="10" x1="5.685" y1="17.466" x2="16.412" y2="17.466"/><line stroke-width="2" stroke-miterlimit="10" x1="5.685" y1="22.892" x2="14.42" y2="22.892"/><line stroke-width="2" stroke-miterlimit="10" x1="5.685" y1="28.316" x2="11.62" y2="28.316"/><g><line stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" x1="25.578" y1="27.312" x2="25.578" y2="21.476"/><line stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" x1="25.613" y1="30.416" x2="25.613" y2="30.3"/></g><polygon stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="25.595,13.218 31.405,23.282 37.216,33.345 25.595,33.345 13.975,33.345 19.785,23.282"/></svg>';
				break;

			case 'claimed-items':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="36.752px" height="38.116px" viewBox="0 0 36.752 38.116" enable-background="new 0 0 36.752 38.116" xml:space="preserve"><g><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M20.554,36.966H3.25c-1.155,0-2.1-0.945-2.1-2.1V3.25c0-1.155,0.945-2.1,2.1-2.1h23.225"/><path stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" d="M26.475,1.15h2.675c1.155,0,2.1,0.945,2.1,2.1v11.787"/><g><g><rect x="6.735" y="7.677" stroke-width="2" stroke-miterlimit="10" width="0.602" height="0.602"/></g><line stroke-width="2" stroke-miterlimit="10" x1="11.227" y1="7.978" x2="25.454" y2="7.978"/></g><g><rect x="6.735" y="13.316" stroke-width="2" stroke-miterlimit="10" width="0.602" height="0.602"/></g><line stroke-width="2" stroke-miterlimit="10" x1="11.227" y1="13.617" x2="21.954" y2="13.617"/><g><rect x="6.735" y="18.955" stroke-width="2" stroke-miterlimit="10" width="0.602" height="0.602"/></g><line stroke-width="2" stroke-miterlimit="10" x1="11.227" y1="19.256" x2="15.82" y2="19.256"/><g><rect x="6.735" y="24.594" stroke-width="2" stroke-miterlimit="10" width="0.602" height="0.603"/></g><g><rect x="6.735" y="30.042" stroke-width="2" stroke-miterlimit="10" width="0.602" height="0.602"/></g><circle stroke-width="2" stroke-miterlimit="10" cx="26.5" cy="26.26" r="9.102"/><g><line stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" x1="26.483" y1="28.012" x2="26.483" y2="22.176"/><line stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" x1="26.518" y1="31.116" x2="26.518" y2="31"/></g></g><text transform="matrix(1 0 0 1 133.0581 197.9316)" font-family="MyriadPro-Regular" font-size="12">' . esc_html__( 'South Africa’s', 'urbango-membership' ) . '</text></svg>';
				break;

			case 'log-out':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="32.351px" height="39.84px" viewBox="0 0 32.351 39.84" enable-background="new 0 0 32.351 39.84" xml:space="preserve"><g><polyline stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" points="1.15,1.15 23.589,1.15 23.59,13.537"/><polyline stroke-width="2" stroke-linejoin="round" stroke-miterlimit="10" points="23.59,18.699 23.59,31.229 12.982,31.229"/><polygon stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="12.864,8.611 12.864,38.69 1.151,31.238 1.15,1.16"/><g><g><g><line stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="31.188" y1="16.192" x2="16.885" y2="16.191"/></g></g><polyline stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="26.987,20.42 31.201,16.205 26.987,11.959"/></g><line stroke-width="2" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" x1="9.358" y1="19.299" x2="9.358" y2="22.625"/></g></svg>';
				break;

			case 'dashboard-menu':
				$html .= '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="12.076px" height="9.068px" viewBox="0 0 12.076 9.068" enable-background="new 0 0 12.076 9.068" xml:space="preserve"><line stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" x1="0.75" y1="0.75" x2="11.326" y2="0.75"/><line stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" x1="0.75" y1="4.534" x2="11.326" y2="4.534"/><line stroke-width="2" stroke-linecap="round" stroke-miterlimit="10" x1="0.75" y1="8.318" x2="11.326" y2="8.318"/></svg>';
				break;

		}

		$html .= '</span>';

		return apply_filters( 'urbango_membership_filter_dashboard_menu_svg_icon', $html, $menu_item );
	}
}