<?php

$profile_params = array(
	'first_name' => array(
		'label' => esc_html__( 'First Name:', 'urbango-membership' ),
		'value' => $first_name,
		'type'  => 'text'
	),
	'last_name'  => array(
		'label' => esc_html__( 'Last Name:', 'urbango-membership' ),
		'value' => $last_name,
		'type'  => 'text'
	),
	'email'      => array(
		'label' => esc_html__( 'Email:', 'urbango-membership' ),
		'value' => $email,
		'type'  => 'email'
	),
	'desription' => array(
		'label' => esc_html__( 'Desription:', 'urbango-membership' ),
		'value' => $description,
		'type'  => 'text'
	),
	'website'    => array(
		'label' => esc_html__( 'Website:', 'urbango-membership' ),
		'value' => $website,
		'type'  => 'url'
	)
);
?>
<div class="edgtf-membership-dashboard-page edgtf-listing-profile-page">
    <div class="edgtf-lp-section-title">
        <h3 class="edgtf-lp-st-title"><?php esc_html_e( 'Profile', 'urbango-membership' ); ?></h3>
        <p class="edgtf-lp-st-text"><?php echo sprintf( esc_html__( 'Welcome to your profile page. This is a brief overview of your user profile. You can change the information listed below by visiting the %s page.', 'urbango-membership' ), '<a itemprop="url" href="' . esc_url( add_query_arg( array( 'user-action' => 'edit-profile' ), urbango_membership_get_dashboard_page_url() ) ) . '">' . esc_html__( 'Edit Profile', 'urbango-membership' ) . '</a>' ); ?></p>
    </div>
    <div class="edgtf-membership-dashboard-page-content">
        <div class="edgtf-profile-image">
			<?php echo urbango_membership_kses_img( $profile_image ); ?>
        </div>
        <div class="edgtf-profile-info">
			<?php foreach ( $profile_params as $key => $value ) {
				if ( ! empty( $value['value'] ) ) {
					$item_class = 'edgtf-profile-info-' . str_replace( '_', '-', $key );
					$item_value = esc_html( $value['value'] );

					switch ( $value['type'] ) {
						case 'email':
							$item_value = '<a href="mailto:' . esc_attr( $value['value'] ) . '">' . esc_attr( $value['value'] ) . '</a>';
							break;
						case 'url':
							$item_value = '<a href="' . esc_url( $value['value'] ) . '" target="_blank">' . esc_attr( $value['value'] ) . '</a>';
							break;
						case 'number':
							$item_value = '<a href="tel:' . str_replace( ' ', '', esc_attr( $value['value'] ) ) . '">' . esc_attr( $value['value'] ) . '</a>';
							break;
					}
					?>
                    <p class="<?php echo esc_attr( $item_class ); ?>">
                        <span><?php echo esc_attr( $value['label'] ); ?></span>
						<?php
						if ( function_exists( 'urbango_edge_get_module_part' ) ) {
							echo urbango_edge_get_module_part( $item_value );
						}
						?>
                    </p>
				<?php } ?>
			<?php } ?>
			<?php if ( ! empty( $profile_socials ) && urbango_listing_is_theme_installed() ) { ?>
                <p class="edgtf-profile-social-info">
                    <span><?php esc_html_e( 'Social Links:', 'urbango-membership' ); ?></span>
					<?php foreach ( $profile_socials as $network ) { ?>
                        <a itemprop="url" class="edgtf-social-icon" href="<?php echo esc_url( $network['link'] ) ?>" target="_blank">
							<?php echo urbango_edge_icon_collections()->renderIcon( $network['class'], 'font_elegant' ); ?>
                        </a>
					<?php } ?>
                </p>
			<?php } ?>
        </div>
    </div>
</div>
