<?php
/**
 * Options map file
 */

if ( ! function_exists( 'urbango_membership_get_pages_list' ) ) {
	function urbango_membership_get_pages_list() {
		$all_pages = array();
		$pages     = get_pages();
		if ( ! empty( $pages ) ) {
			$all_pages[] = esc_html__( 'Default', 'urbango-membership' );

			foreach ( $pages as $page ) {
				$all_pages[ $page->ID ] = esc_html( $page->post_title );
			}
		}

		return $all_pages;
	}
}

if ( ! function_exists( 'urbango_membership_options_map' ) ) {
	function urbango_membership_options_map( $page ) {
		
		if ( urbango_membership_theme_installed() ) {
			
			$panel_social_login = urbango_edge_add_admin_panel(
				array(
					'page'  => $page,
					'name'  => 'panel_social_login',
					'title' => esc_html__( 'Enable Social Login', 'urbango-membership' )
				)
			);

			urbango_edge_add_admin_field(
				array(
					'type'          => 'text',
					'name'          => 'edgtf_membership_privacy_policy_text',
					'label'         => esc_html__( 'Privacy Policy Text', 'urbango-membership' ),
					'description'   => esc_html__( 'Enter privacy policy text for registration modal form', 'urbango-membership' ),
					'parent'        => $panel_social_login
				)
			);

			urbango_edge_add_admin_field(
				array(
					'type'          => 'select',
					'name'          => 'edgtf_membership_privacy_policy_link',
					'label'         => esc_html__( 'Privacy Policy Link', 'urbango-membership' ),
					'description'   => esc_html__( 'Choose Privacy Policy Link page to link from registration modal form', 'urbango-membership' ),
					'default_value' => '',
					'options'       => urbango_membership_get_pages_list(),
					'parent'        => $panel_social_login
				)
			);

			urbango_edge_add_admin_field(
				array(
					'type'          => 'text',
					'name'          => 'edgtf_membership_privacy_policy_link_text',
					'label'         => esc_html__( 'Privacy Policy Link Text', 'urbango-membership' ),
					'description'   => esc_html__( 'Enter privacy policy link text for registration modal form. Default value is "privacy policy"', 'urbango-membership' ),
					'parent'        => $panel_social_login
				)
			);
			
			urbango_edge_add_admin_field(
				array(
					'type'          => 'yesno',
					'name'          => 'enable_social_login',
					'default_value' => 'no',
					'label'         => esc_html__( 'Enable Social Login', 'urbango-membership' ),
					'description'   => esc_html__( 'Enabling this option will allow login from social networks of your choice', 'urbango-membership' ),
					'parent'        => $panel_social_login
				)
			);
			
			$panel_enable_social_login = urbango_edge_add_admin_panel(
				array(
					'page'       => $page,
					'name'       => 'panel_enable_social_login',
					'title'      => esc_html__( 'Enable Login via', 'urbango-membership' ),
					'dependency' => array(
						'show' => array(
							'enable_social_login' => 'yes'
						)
					)
				)
			);
			
			urbango_edge_add_admin_field(
				array(
					'type'          => 'yesno',
					'name'          => 'enable_facebook_social_login',
					'default_value' => 'no',
					'label'         => esc_html__( 'Facebook', 'urbango-membership' ),
					'description'   => esc_html__( 'Enabling this option will allow login via Facebook', 'urbango-membership' ),
					'parent'        => $panel_enable_social_login
				)
			);
			
			$enable_facebook_social_login_container = urbango_edge_add_admin_container(
				array(
					'name'       => 'enable_facebook_social_login_container',
					'parent'     => $panel_enable_social_login,
					'dependency' => array(
						'show' => array(
							'enable_facebook_social_login' => 'yes'
						)
					)
				)
			);
			
			urbango_edge_add_admin_field(
				array(
					'type'          => 'text',
					'name'          => 'enable_facebook_login_fbapp_id',
					'default_value' => '',
					'label'         => esc_html__( 'Facebook App ID', 'urbango-membership' ),
					'description'   => esc_html__( 'Copy your application ID form created Facebook Application', 'urbango-membership' ),
					'parent'        => $enable_facebook_social_login_container
				)
			);
		}
	}
	
	add_action( 'urbango_edge_action_social_options', 'urbango_membership_options_map' );
}
