<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

?>
<div class="edgtf-report-form-holder">
    <div class="edgtf-report-form-inner">
        <a class="edgtf-report-close" href="#">
			<?php echo urbango_edge_icon_collections()->renderIcon( 'icon_close', 'font_elegant' ); ?>
        </a>
        <form class="edgtf-report-form" data-id="" method="POST">
            <h5 class="edgtf-report-title">
                <span class="edgtf-report-title-label"><?php esc_html_e( 'Report this Listing', 'urbango-listing' ); ?></span>
            </h5>
            <textarea name="edgtf_report_message" id="edgtf-report-message" placeholder="<?php esc_attr_e( 'What is wrong with this listing?', 'urbango-listing' ); ?>" required></textarea>

			<?php if ( urbango_listing_is_core_plugin_installed() ) {
				echo urbango_edge_get_button_html( array(
					'custom_class' => 'edgtf-report-submit',
					'html_type'    => 'button',
					'text'         => esc_html__( 'Send Your Report', 'urbango-listing' )
				) );
			} ?>

            <input type="hidden" id="edgtf-report-user-id" value="<?php echo get_current_user_id(); ?>">

			<?php wp_nonce_field( 'urbango_listing_validate_listing_item_report_form', 'urbango_listing_nonce_listing_item_report_form' ); ?>
        </form>
        <div class="edgtf-report-form-response"></div>
    </div>
</div>