<?php

namespace UrbanGoListing\CPT\Report;

use UrbanGoListing\PostTypes\PostTypesInterface;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Class ReportRegister
 * @package UrbanGoListing\CPT\Ads
 */
class ReportRegister implements PostTypesInterface {
	
	/**
	 * Singleton variables
	 */
	private $base;
	
	public function __construct() {
		$this->base = 'report';
	}
	
	/**
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}
	
	/**
	 * Registers custom post type and taxonomies
	 */
	public function register() {
		$this->registerPostType();
	}
	
	/**
	 * Registers custom post type with WordPress
	 */
	private function registerPostType() {
		$menuPosition = 34;
		$menuIcon     = 'dashicons-warning';
		
		register_post_type( $this->getBase(),
			array(
				'labels'              => array(
					'name'          => esc_html__( 'UrbanGo Reports', 'urbango-listing' ),
					'singular_name' => esc_html__( 'Report Item', 'urbango-listing' ),
					'add_item'      => esc_html__( 'New Report Item', 'urbango-listing' ),
					'add_new_item'  => esc_html__( 'Add New Report Item', 'urbango-listing' ),
					'edit_item'     => esc_html__( 'Edit Report Item', 'urbango-listing' )
				),
				'public'              => true,
				'has_archive'         => false,
				'rewrite'             => array( 'slug' => $this->getBase() ),
				'menu_position'       => $menuPosition,
				'show_in_menu'        => true,
				'show_ui'             => true,
				'supports'            => array(
					'title'
				),
				'menu_icon'           => $menuIcon,
				'exclude_from_search' => true,
				'show_in_admin_bar'   => false,
				'show_in_nav_menus'   => false,
				'publicly_queryable'  => false,
				'query_var'           => false,
				'capability_type'     => $this->getBase(),
				'map_meta_cap'        => true
			)
		);
	}
}
