<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_allow_report_cpt_for_meta_box_functions' ) ) {
	function urbango_listing_allow_report_cpt_for_meta_box_functions( $post_types ) {
		$post_types[] = 'report';
		
		return $post_types;
	}
	
	add_filter( 'urbango_edge_filter_meta_box_post_types_save', 'urbango_listing_allow_report_cpt_for_meta_box_functions' );
	add_filter( 'urbango_edge_filter_meta_box_post_types_remove', 'urbango_listing_allow_report_cpt_for_meta_box_functions' );
}

if ( ! function_exists( 'urbango_listing_register_report_custom_post_types' ) ) {
	function urbango_listing_register_report_custom_post_types( $cpt_classes ) {
		$cpt_class = array(
			'UrbanGoListing\CPT\Report\ReportRegister'
		);
		
		return array_merge( $cpt_classes, $cpt_class );
	}
	
	add_filter( 'urbango_listing_filter_register_custom_post_types', 'urbango_listing_register_report_custom_post_types' );
}

if ( ! function_exists( 'urbango_listing_get_admin_count_of_new_reports' ) ) {
	function urbango_listing_get_admin_count_of_new_reports( $menu ) {
		$post_type    = 'report';
		$post_status  = 'pending';
		$posts_number = wp_count_posts( $post_type, 'readable' );
		
		$pending_count = 0;
		if ( ! empty( $posts_number->$post_status ) ) {
			$pending_count = $posts_number->$post_status;
		}
		
		foreach ( $menu as $menu_key => $menu_data ) {
			if ( 'edit.php?post_type=' . $post_type != $menu_data[2] ) {
				continue;
			}
			
			if ( $pending_count > 0 ) {
				$menu[ $menu_key ][0] .= '<span class="update-plugins"><span class="plugin-count">' . intval( $pending_count ) . '</span></span>';
			}
		}
		
		return $menu;
	}
	
	add_filter( 'add_menu_classes', 'urbango_listing_get_admin_count_of_new_reports' );
}

if ( ! function_exists( 'urbango_listing_manage_admin_report_posts_columns' ) ) {
	function urbango_listing_manage_admin_report_posts_columns( $columns ) {
		$columns['edgtf-report-status'] = esc_html__( 'Status', 'urbango-listing' );
		
		return $columns;
	}
	
	add_filter( 'manage_report_posts_columns', 'urbango_listing_manage_admin_report_posts_columns' );
}

if ( ! function_exists( 'urbango_listing_manage_admin_report_posts_custom_column' ) ) {
	function urbango_listing_manage_admin_report_posts_custom_column( $column_name, $post_ID ) {
		
		if ( $column_name == 'edgtf-report-status' ) {
			$report_approved         = get_post_meta( $post_ID, 'edgtf_listing_reported_status_action_meta', true );
			$reported_author_message = get_post_meta( $post_ID, 'edgtf_listing_reported_listing_author_message_meta', true );
			
			$edit_link_class = 'post-edit-link';
			
			if ( $report_approved === 'yes' ) {
				
				if ( ! empty( $reported_author_message ) ) {
					$edit_link_class .= ' edgtf-resubmitted';
					
					$icon  = 'dashicons-image-rotate';
					$label = esc_html__( 'Resubmitted', 'urbango-listing' );
				} else {
					$edit_link_class .= ' edgtf-approved';
					
					$icon  = 'dashicons-yes';
					$label = esc_html__( 'Approved', 'urbango-listing' );
				}
			} else {
				$edit_link_class .= ' edgtf-declined';
				
				$icon  = 'dashicons-no-alt';
				$label = esc_html__( 'Declined', 'urbango-listing' );
			}
			
			edit_post_link( sprintf( '<span class="edgtf-report-icon dashicons %s"></span><span class="edgtf-report-label">%s</span>', $icon, $label ), '', '', 0, $edit_link_class );
		}
	}
	
	add_filter( 'manage_report_posts_custom_column', 'urbango_listing_manage_admin_report_posts_custom_column', 10, 2 );
}

if ( ! function_exists( 'urbango_listing_get_listing_item_report_form' ) ) {
	function urbango_listing_get_listing_item_report_form() {
		$allowed_pages = apply_filters( 'urbango_listing_filter_allowed_report_pages', array() );
		
		if ( ! empty( $allowed_pages ) && is_user_logged_in() ) {
			foreach ( $allowed_pages as $allowed_page ) {
				if ( is_singular( $allowed_page ) ) {
					urbango_listing_get_module_template_part( 'cpt', 'report', 'templates/report-form' );
				}
			}
		}
	}
	
	add_action( 'urbango_edge_action_before_page_header', 'urbango_listing_get_listing_item_report_form' );
}

if ( ! function_exists( 'urbango_listing_get_user_reported_items' ) ) {
	function urbango_listing_get_user_reported_items() {
		$all_reports         = urbango_listing_get_cpt_items( 'report' );
		$user_listings       = urbango_listing_get_cpt_items( 'listing-item', array( 'post_status' => array( 'pending', 'draft' ), 'author' => get_current_user_id() ) );
		$user_reported_items = array();
		
		if ( ! empty( $all_reports ) ) {
			foreach ( $all_reports as $id => $title ) {
				$report_approved  = get_post_meta( $id, 'edgtf_listing_reported_status_action_meta', true );
				$reported_listing = get_post_meta( $id, 'edgtf_listing_reported_listing_item_id_meta', true );
				
				if ( $report_approved === 'yes' && ! empty( $reported_listing ) && array_key_exists( intval( $reported_listing ), $user_listings ) ) {
					$user_reported_items[ $id ] = intval( $reported_listing );
				}
			}
		}
		
		return $user_reported_items;
	}
}

if ( ! function_exists( 'urbango_listing_get_user_reported_items_count' ) ) {
	function urbango_listing_get_user_reported_items_count() {
		$reports_count       = 0;
		$user_reported_items = urbango_listing_get_user_reported_items();
		
		if ( ! empty( $user_reported_items ) ) {
			$reports_count = count( $user_reported_items );
		}
		
		return intval( $reports_count );
	}
}

if ( ! function_exists( 'urbango_listing_check_is_item_reported' ) ) {
	function urbango_listing_check_is_item_reported( $item_id ) {
		$is_reported         = false;
		$user_reported_items = urbango_listing_get_user_reported_items();
		
		if ( ! empty( $user_reported_items ) && ! empty( $item_id ) && in_array( $item_id, $user_reported_items ) ) {
			$is_reported = true;
		}
		
		return $is_reported;
	}
}

if ( ! function_exists( 'urbango_listing_send_listing_item_report' ) ) {
	function urbango_listing_send_listing_item_report() {
		if ( isset( $_POST['reportData'] ) ) {
			$error           = false;
			$responseMessage = '';
			
			$data  = $_POST['reportData'];
			$nonce = $data['nonce'];
			
			if ( wp_verify_nonce( $nonce, 'urbango_listing_validate_listing_item_report_form' ) ) {
				
				// Validate input fields
				if ( empty( $data['itemID'] ) ) {
					$error           = true;
					$responseMessage = esc_html__( 'Item ID is invalid.', 'urbango-listing' );
				}
				
				if ( empty( $data['userID'] ) ) {
					$error           = true;
					$responseMessage = esc_html__( 'User is not logged in.', 'urbango-listing' );
				}
				
				if ( empty( $data['message'] ) ) {
					$error           = true;
					$responseMessage = esc_html__( 'Please enter a valid message.', 'urbango-listing' );
				}
				
				if ( $error ) {
					urbango_listing_get_ajax_status( 'error', $responseMessage );
				} else {
					// Get necessary variables
					$post_id = intval( esc_attr( $data['itemID'] ) );
					$user_id = intval( esc_attr( $data['userID'] ) );
					$message = esc_attr( esc_html( $data['message'] ) );
					
					// Check is user already reported this item
					$already_reported = false;
					
					$all_reports = urbango_listing_get_cpt_items( 'report' );
					if ( ! empty( $all_reports ) ) {
						foreach ( $all_reports as $id => $title ) {
							$reported_listing = get_post_meta( $id, 'edgtf_listing_reported_listing_item_id_meta', true );
							$reported_by_user = get_post_meta( $id, 'edgtf_listing_reported_user_id_meta', true );
							
							if ( ! empty( $reported_listing ) && intval( $reported_listing ) === $post_id ) {
								$already_reported = true;
								
								if ( ! empty( $reported_by_user ) && intval( $reported_by_user ) === $user_id ) {
									$responseMessage = esc_html__( 'You already reported this item.', 'urbango-listing' );
								} else {
									$responseMessage = esc_html__( 'This item is already reported.', 'urbango-listing' );
								}
							}
						}
					}
					
					if ( $already_reported ) {
						urbango_listing_get_ajax_status( 'error', $responseMessage );
					} else {
						$params               = array();
						$params['meta_input'] = array();
						
						$params['post_status'] = 'pending';
						$params['post_type']   = 'report';
						$params['post_title']  = sprintf( esc_html__( '%s - %s', 'urbango-listing' ), get_the_title( $post_id ), get_the_author_meta( 'display_name', get_post_field('post_author', $post_id ) ) );
						
						
						$params['meta_input']['edgtf_listing_reported_listing_item_id_meta']       = $post_id;
						$params['meta_input']['edgtf_listing_reported_user_id_meta']               = $user_id;
						$params['meta_input']['edgtf_listing_reported_user_reported_message_meta'] = $message;
						
						$create_report = wp_insert_post( $params );
						
						if ( ! is_wp_error( $create_report ) ) {
							// Remove data from global post variable after submission
							unset( $_POST['reportData'] );
							
							urbango_listing_get_ajax_status( 'success', esc_html__( 'Report is successfully sent.', 'urbango-listing' ) );
						} else {
							urbango_listing_get_ajax_status( 'error', esc_html__( 'Error while creating report.', 'urbango-listing' ) );
						}
					}
				}
			} else {
				urbango_listing_get_ajax_status( 'error', esc_html__( 'Nonce is invalid.', 'urbango-listing' ) );
			}
		} else {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'Report is not valid please try again to send it.', 'urbango-listing' ) );
		}
	}
	
	add_action( 'wp_ajax_urbango_listing_send_listing_item_report', 'urbango_listing_send_listing_item_report' );
}

if ( ! function_exists( 'urbango_listing_resubmit_reported_item' ) ) {
	function urbango_listing_resubmit_reported_item() {
		if ( isset( $_POST['reportData'] ) ) {
			$error           = false;
			$responseMessage = '';
			
			$data  = $_POST['reportData'];
			$nonce = $data['nonce'];
			
			if ( wp_verify_nonce( $nonce, 'urbango_listing_validate_resubmit_reported_item' ) ) {
				
				// Validate input fields
				if ( empty( $data['itemID'] ) ) {
					$error           = true;
					$responseMessage = esc_html__( 'Item ID is invalid.', 'urbango-listing' );
				}
				
				if ( empty( $data['message'] ) ) {
					$error           = true;
					$responseMessage = esc_html__( 'Please enter a valid message.', 'urbango-listing' );
				}
				
				if ( $error ) {
					urbango_listing_get_ajax_status( 'error', $responseMessage );
				} else {
					// Get necessary variables
					$post_id = intval( esc_attr( $data['itemID'] ) );
					$message = esc_attr( esc_html( $data['message'] ) );
					
					// Check is user already resubmit this item
					$already_resubmitted = false;
					$all_reports         = urbango_listing_get_cpt_items( 'report' );
					
					if ( ! empty( $all_reports ) ) {
						foreach ( $all_reports as $id => $title ) {
							$reported_listing = get_post_meta( $id, 'edgtf_listing_reported_listing_item_id_meta', true );
						
							if ( ! empty( $reported_listing ) && intval( $reported_listing ) === $post_id ) {
								$reported_author_message = get_post_meta( $id, 'edgtf_listing_reported_listing_author_message_meta', true );
								
								if ( ! empty( $reported_author_message ) ) {
									$already_resubmitted = true;
									$responseMessage     = esc_html__( 'You already resubmitted this item.', 'urbango-listing' );
								} else {
									// Set report post args
									$params = array(
										'post_status' => 'pending',
										'post_type'   => 'report',
										'ID'          => $id,
										'meta_input'  => array(
											'edgtf_listing_reported_listing_author_message_meta' => $message
										)
									);
									
									$update_report = wp_update_post( $params );
									
									if ( ! is_wp_error( $update_report ) ) {
										// Remove data from global post variable after submission
										unset( $_POST['reportData'] );
										
										urbango_listing_get_ajax_status( 'success', esc_html__( 'Resubmission is successfully sent.', 'urbango-listing' ) );
									} else {
										urbango_listing_get_ajax_status( 'error', esc_html__( 'Error while updating reported item.', 'urbango-listing' ) );
									}
								}
							} else {
								$already_resubmitted = true;
								$responseMessage     = esc_html__( 'You already resubmitted this item.', 'urbango-listing' );
							}
						}
					}
					
					if ( $already_resubmitted ) {
						urbango_listing_get_ajax_status( 'error', $responseMessage );
					}
				}
			} else {
				urbango_listing_get_ajax_status( 'error', esc_html__( 'Nonce is invalid.', 'urbango-listing' ) );
			}
		} else {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'Resubmission reported item is not valid please try to resubmit again.', 'urbango-listing' ) );
		}
	}
	
	add_action( 'wp_ajax_urbango_listing_resubmit_reported_item', 'urbango_listing_resubmit_reported_item' );
}

if ( ! function_exists( 'urbango_listing_change_post_status_for_reported_listing_items' ) ) {
	function urbango_listing_change_post_status_for_reported_listing_items( $post_id ) {
		
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}
		
		if ( ! isset( $_POST['_wpnonce'] ) ) {
			return;
		}
		
		if ( ! urbango_listing_check_is_user_admin() || empty( $post_id ) ) {
			return;
		}
		
		if ( get_post_type( $post_id ) !== 'report' || get_post_status( $post_id ) !== 'publish' ) {
			return;
		}
		
		$reported_listing_id = get_post_meta( $post_id, 'edgtf_listing_reported_listing_item_id_meta', true );
		
		if ( ! empty( $reported_listing_id ) ) {
			global $wpdb;
			
			$query = '';
			
			$reported_status_action  = get_post_meta( $post_id, 'edgtf_listing_reported_status_action_meta', true );
			$reported_author_message = get_post_meta( $post_id, 'edgtf_listing_reported_listing_author_message_meta', true );
			
			if ( $reported_status_action === 'yes' ) {
				
				if ( ! empty( $reported_author_message ) ) {
					update_post_meta( $post_id, 'edgtf_listing_reported_listing_author_message_meta', '' );
				}
				
				$query = "UPDATE " . $wpdb->prefix . "posts SET post_status='draft' WHERE post_type='listing-item' AND ID='" . esc_attr( intval( $reported_listing_id ) ) . "'";
			} else if ( $reported_status_action === 'no' && ! empty( $reported_author_message ) ) {
				$query = "UPDATE " . $wpdb->prefix . "posts SET post_status='publish' WHERE post_type='listing-item' AND ID='" . esc_attr( intval( $reported_listing_id ) ) . "'";
			}
			
			// Update the post into the database
			if ( ! empty( $query ) ) {
				$wpdb->query( $query );
			}
		}
	}
	
	add_action( 'save_post', 'urbango_listing_change_post_status_for_reported_listing_items' );
}
