(function ($) {
	'use strict';
	
	var report = {};
	edgtf.modules.report = report;
	
	report.edgtfOnDocumentReady = edgtfOnDocumentReady;
	
	$(document).ready(edgtfOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		edgtfInitReport();
		edgtfResubmitReportedItemFromDashboard();
	}
	
	/**
	 * Initializes report functionality
	 */
	function edgtfInitReport() {
		var reportOpener = $('.edgtf-report-opener'),
			reportHolder = $('.edgtf-report-form-holder');
		
		if (reportOpener.length) {
			
			if (reportHolder.length) {
				var reportForm = reportHolder.find('.edgtf-report-form'),
					reportFormCloseButton = reportHolder.find('.edgtf-report-close'),
					responseMessage = reportHolder.find('.edgtf-report-form-response');
				
				reportFormCloseButton.on('click', function (e) {
					e.preventDefault();
					
					reportHolder.fadeOut(300).removeClass('edgtf-opened');
				});
				
				// Close form on esc key
				$(window).on('keyup', function (e) {
					if (reportHolder.hasClass('edgtf-opened') && e.keyCode === 27) {
						reportHolder.fadeOut(300).removeClass('edgtf-opened');
					}
				});
				
				reportForm.on('submit', function (e) {
					e.preventDefault();
					
					if (edgtf.body.hasClass('logged-in')) {
						responseMessage.empty().html('<span class="fa fa-spinner fa-spin" aria-hidden="true"></span>');
						
						var reportData = {
							message: reportForm.find('#edgtf-report-message').val(),
							itemID: reportForm.data('id'),
							userID: reportForm.find('#edgtf-report-user-id').val(),
							nonce: reportForm.find('#urbango_listing_nonce_listing_item_report_form').val()
						};
						
						var requestData = {
							action: 'urbango_listing_send_listing_item_report',
							reportData: reportData
						};
						
						$.ajax({
							type: "POST",
							url: edgtfGlobalVars.vars.edgtfAjaxUrl,
							data: requestData,
							success: function (data) {
								var response = JSON.parse(data);
								
								if (response.status === 'success') {
									responseMessage.html(response.message);
									
									setTimeout(function () {
										reportHolder.fadeOut(300).removeClass('edgtf-opened');
									}, 800);
								} else {
									responseMessage.html(response.message);
								}
							}
						});
					} else {
						// Trigger event.
						$(document.body).trigger('open_user_login_trigger');
					}
				});
			}
			
			reportOpener.each(function () {
				var thisReportOpener = $(this),
					itemID = thisReportOpener.data('id');
				
				thisReportOpener.off().on('click', function (e) {
					e.preventDefault();
					
					if (edgtf.body.hasClass('logged-in')) {
						reportHolder.fadeIn(300).addClass('edgtf-opened');
						
						// Set default values
						reportForm.data('id', itemID).find('#edgtf-report-message').val('');
						responseMessage.empty();
					} else {
						// Trigger event.
						$(document.body).trigger('open_user_login_trigger');
					}
				});
			});
		}
	}
	
	function edgtfResubmitReportedItemFromDashboard() {
		var button = $('.edgtf-listing-item-resubmit');
		
		if (button.length) {
			button.each(function () {
				var thisButton = $(this),
					listingId = thisButton.data('listing-id'),
					itemHolder = thisButton.parents('.edgtf-lp-reported-item'),
					messageHolder = itemHolder.find('.edgtf-resubmit-message'),
					responseHolder = itemHolder.find('.edgtf-lp-ri-response'),
					confirmText = thisButton.data('confirm-text');
				
				thisButton.on('click', function (e) {
					e.preventDefault();
					
					var confirmDelete = confirm(confirmText);

					if (confirmDelete) {
						thisButton.parent().append('<span class="edgtf-resubmit-spinner fa fa-spinner fa-spin" aria-hidden="true"></span>');

						var ajaxData = {
							'action': 'urbango_listing_resubmit_reported_item',
							'reportData': {
								itemID: listingId,
								message: messageHolder.val(),
								nonce: itemHolder.find('#urbango_listing_nonce_resubmit_reported_item').val()
							}
						};

						$.ajax({
							type: 'POST',
							data: ajaxData,
							url: edgtfGlobalVars.vars.edgtfAjaxUrl,
							success: function (data) {
								var response = JSON.parse(data);
								
								responseHolder.html(response.message);
								
								// Reset values
								thisButton.parent().find('.edgtf-resubmit-spinner').remove();
								messageHolder.val('');
								setTimeout(function(){
									responseHolder.empty();
								}, 3000);
							}
						});
					}
				});
			});
		}
	}
	
})(jQuery);