<?php

namespace UrbanGoListing\CPT;

use UrbanGoListing\PostTypes;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Class PostTypesLoader
 * @package UrbanGoListing\CPT
 */
class PostTypesRegister {
	/**
	 * @var private instance of the class
	 */
	private static $instance;
	/**
	 * @var array
	 */
	private $postTypes = array();
	
	/**
	 * Private construct because of Singletone
	 */
	public function __construct() {
		$this->register();
	}
	
	/**
	 * Returns current instance of class
	 * @return PostTypesRegister
	 */
	public static function getInstance() {
		if ( self::$instance == null ) {
			return new self;
		}
		
		return self::$instance;
	}
	
	/**
	 * Adds post type to post types array
	 *
	 * @param PostTypes\PostTypesInterface $postTypes
	 */
	private function addPostType( PostTypes\PostTypesInterface $postTypes ) {
		if ( ! array_key_exists( $postTypes->getBase(), $this->postTypes ) ) {
			$this->postTypes[ $postTypes->getbase() ] = $postTypes;
		}
	}
	
	/**
	 * Returns post type object by it's slug
	 *
	 * @param $slug
	 *
	 * @return mixed
	 */
	public function getPostType( $slug ) {
		if ( array_key_exists( $slug, $this->postTypes ) ) {
			return $this->postTypes[ $slug ];
		}
	}
	
	/**
	 * Adds all post types
	 *
	 * @see PostTypesLoader::addPostType()
	 */
	private function addPostTypes() {
		$cpt_class_name = apply_filters( 'urbango_listing_filter_register_custom_post_types', $cpt_class_name = array() );
		
		if ( ! empty( $cpt_class_name ) ) {
			foreach ( $cpt_class_name as $cpt_class ) {
				$this->addPostType( new $cpt_class );
			}
		}
	}
	
	/**
	 * Class addPostTypes method, loops through each post type in array and calls register method
	 */
	public function register() {
		$this->addPostTypes();
		
		foreach ( $this->postTypes as $postType ) {
			$postType->register();
		}
	}
}
