<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_init_post_types_register_instance' ) ) {
	/**
	 * Register custom post types
	 */
	function urbango_listing_init_post_types_register_instance() {
		new UrbanGoListing\CPT\PostTypesRegister();
		flush_rewrite_rules();
	}
	
	add_action( 'after_setup_theme', 'urbango_listing_init_post_types_register_instance' );
}

if ( ! function_exists( 'urbango_listing_include_custom_post_types_files' ) ) {
	/**
	 * Loads all custom post types by going through all folders that are placed directly in post types folder
	 */
	function urbango_listing_include_custom_post_types_files() {
		if ( urbango_listing_is_theme_installed() ) {
			foreach ( glob( URBANGO_LISTING_CPT_PATH . '/*/load.php' ) as $cpt ) {
				require_once $cpt;
			}
		}
	}
	
	add_action( 'after_setup_theme', 'urbango_listing_include_custom_post_types_files', 1 );
}
