<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$package_values     = urbango_listing_package_list_shortcode_item_values( get_the_ID() );
$featured           = get_post_meta( get_the_ID(), 'edgtf_package_featured_meta', true );
$params['featured'] = $featured;
$additional_info    = get_post_meta( get_the_ID(), 'edgtf_package_additional_info_meta', true );
?>
<li class="edgtf-pl-item <?php echo esc_attr( $this_object->getArticleClasses( $params ) ); ?>">
	<div class="edgtf-pli-inner">
		<div class="edgtf-pli-title-holder">
			<h5 class="edgtf-pli-title"><?php the_title(); ?></h5>
			<?php if ( $featured === 'yes' ) { ?>
				<div class="edgtf-pli-badge"><?php echo urbango_listing_get_featured_mark(); ?></div>
			<?php } ?>
		</div>
		<div class="edgtf-pli-price">
			<?php if ( preg_match( '/[^A-Za-z]/', $package_values['price'] ) ) { ?>
				<span class="edgtf-pli-price-currency">
			        <?php echo esc_html( $package_values['currency'] ); ?>
			    </span>
				<span class="edgtf-pli-price-value">
			        <?php echo esc_html( $package_values['price'] ); ?>
			    </span>
			<?php } else { ?>
				<span class="edgtf-pli-price-value">
			        <?php echo esc_html( $package_values['price'] ); ?>
			    </span>
			<?php } ?>
		</div>
		<div class="edgtf-pli-content">
			<?php if ( isset( $package_values['listings_inluded'] ) && $package_values['listings_inluded'] !== '' ) { ?>
				<div class="edgtf-pli-listing">
					<?php echo urbango_listing_package_get_item_icon( $package_values['listings_inluded'], 'edgtf-pli-listing-icon' ); ?>
					<span class="edgtf-pli-listing-label">
			            <?php esc_html_e( 'Listings Included:', 'urbango-listing' ); ?>
			        </span>
					<span class="edgtf-pli-listing-value">
			            <?php echo esc_html( $package_values['listings_inluded'] ); ?>
			        </span>
				</div>
			<?php } ?>
			<?php if ( isset( $package_values['featured_inluded'] ) && $package_values['featured_inluded'] !== '' ) { ?>
				<div class="edgtf-pli-featured">
					<?php echo urbango_listing_package_get_item_icon( $package_values['featured_inluded'], 'edgtf-pli-featured-icon' ); ?>
					<span class="edgtf-pli-featured-label">
			            <?php esc_html_e( 'Featured Included:', 'urbango-listing' ); ?>
			        </span>
					<span class="edgtf-pli-featured-value">
			            <?php echo esc_html( $package_values['featured_inluded'] ); ?>
			        </span>
				</div>
			<?php } ?>
			<?php if ( isset( $package_values['duration'] ) && $package_values['duration'] !== '' ) { ?>
				<div class="edgtf-pli-duration">
					<?php echo urbango_listing_package_get_item_icon( $package_values['duration'], 'edgtf-pli-duration-icon' ); ?>
					<span class="edgtf-pli-duration-label">
			            <?php esc_html_e( 'Duration (months):', 'urbango-listing' ); ?>
			        </span>
					<span class="edgtf-pli-duration-value">
			            <?php echo esc_html( $package_values['duration'] ); ?>
			        </span>
				</div>
			<?php } ?>
			<?php if ( ! empty( $additional_info ) && is_array( $additional_info ) ) {
				foreach ( $additional_info as $info ) { ?>
					<div class="edgtf-pli-additional-info">
						<?php if ( isset( $info['checked'] ) ) {
							echo urbango_listing_package_get_item_icon( $info['checked'] === 'yes', 'edgtf-pli-additional-info-icon' );
						} else {
							echo urbango_listing_package_get_item_icon( false, 'edgtf-pli-additional-info-icon' );
						} ?>
						<?php if ( isset( $info['label'] ) && ! empty( $info['label'] ) ) { ?>
							<span class="edgtf-pli-additional-info-label">
								<?php echo esc_html( $info['label'] ); ?>
							</span>
						<?php } ?>
						<?php if ( isset( $info['value'] ) && $info['value'] !== '' ) { ?>
							<span class="edgtf-pli-duration-value">
								<?php echo esc_html( $info['value'] ); ?>
							</span>
						<?php } ?>
					</div>
				<?php }
			} ?>
			<?php if ( isset( $package_values['ads'] ) ) { ?>
				<div class="edgtf-pli-ads">
					<?php if ( $package_values['ads'] === 'yes' ) {
						$ads_icon_value = true;
						$ads_label      = esc_html__( 'Ads Included', 'urbango-listing' );
					} else {
						$ads_icon_value = false;
						$ads_label      = esc_html__( 'Ads Excluded', 'urbango-listing' );
					}
					
					echo urbango_listing_package_get_item_icon( $ads_icon_value, 'edgtf-pli-ads-icon' );
					?>
					<span class="edgtf-pli-ads-label">
			            <?php echo esc_html( $ads_label ); ?>
			        </span>
				</div>
			<?php } ?>
		</div>
		<div class="edgtf-pli-action">
			<?php urbango_listing_get_package_buy_form(); ?>
		</div>
	</div>
</li>