<?php

namespace UrbanGoListing\CPT\Shortcodes\Package;

use UrbanGoListing\Lib;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

class PackageList implements Lib\ShortcodeInterface {
    private $base;

    public function __construct() {
        $this->base = 'edgtf_package_list';

        add_action( 'vc_before_init', array( $this, 'vcMap' ) );
    }

    public function getBase() {
        return $this->base;
    }
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'     => esc_html__( 'Package List', 'urbango-listing' ),
					'base'     => $this->getBase(),
					'category' => esc_html__( 'by URBANGO LISTING', 'urbango-listing' ),
					'icon'     => 'icon-wpb-package-list extended-custom-listing-icon',
					'params'   => array(
						array(
							'type'        => 'dropdown',
							'param_name'  => 'category',
							'heading'     => esc_html__( 'Package Category', 'urbango-listing' ),
							'value'       => array_flip( urbango_listing_get_cpt_taxonomy_items( 'category', true, 'package' ) ),
							'save_always' => true
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'number_of_columns',
							'heading'     => esc_html__( 'Number of Columns', 'urbango-listing' ),
							'description' => esc_html__( 'Set number of columns for your list. Default value is three', 'urbango-listing' ),
							'value'       => array_flip( urbango_edge_get_number_of_columns_array( true ) )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'space_between_items',
							'heading'     => esc_html__( 'Space Between Items', 'urbango-listing' ),
							'description' => esc_html__( 'Set space size between items for your list. Default value is normal', 'urbango-listing' ),
							'value'       => array_flip( urbango_edge_get_space_between_items_array() )
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'category'            => '',
			'number_of_columns'   => 'three',
			'space_between_items' => 'normal'
		);
		$params = shortcode_atts( $args, $atts );
		
		$additional_params = array();
		
		$query_array                        = $this->getQueryArray( $params );
		$query_results                      = new \WP_Query( $query_array );
		$additional_params['query_results'] = $query_results;
		
		$additional_params['holder_classes']       = $this->getHolderClasses( $params, $args );
		$additional_params['holder_inner_classes'] = $this->getHolderInnerClasses( $params );
		
		$params['this_object'] = $this;
		
		$html = urbango_listing_get_module_template_part( 'cpt-package', 'package-list', 'holder', '', $params, $additional_params, false );
		
		return $html;
	}
	
	/**
	 * Generates query results
	 *
	 * @param $params
	 *
	 * @return array
	 */
	public function getQueryArray( $params ) {
		$query_array = array(
			'post_status'    => 'publish',
			'post_type'      => 'package',
			'posts_per_page' => - 1,
			'meta_key'       => 'edgtf_package_price_meta',
			'orderby'        => 'meta_value_num',
			'order'          => 'ASC'
		);
		
		// Taxonomy query values
		if ( ! empty( $params['category'] ) ) {
			$tax_query = array();
			
			if ( ! empty( $params['category'] ) ) {
				$tax_query[] = array(
					'taxonomy' => 'package-category',
					'terms'    => $params['category']
				);
			}
			
			$query_array['tax_query'] = $tax_query;
		}
		
		return $query_array;
	}
	
	public function getHolderClasses( $params, $args ) {
		$classes = array();
		
		$classes[] = 'edgtf-grid-list edgtf-disable-bottom-space';
		$classes[] = ! empty( $params['number_of_columns'] ) ? 'edgtf-' . $params['number_of_columns'] . '-columns' : 'edgtf-' . $args['number_of_columns'] . '-columns';
		$classes[] = ! empty( $params['space_between_items'] ) ? 'edgtf-' . $params['space_between_items'] . '-space' : 'edgtf-' . $args['space_between_items'] . '-space';
		
		return implode( ' ', $classes );
	}
	
	public function getHolderInnerClasses( $params ) {
		$classes = array();
		
		$classes[] = 'edgtf-outer-space';
		
		return implode( ' ', $classes );
	}
	
	public function getArticleClasses( $params ) {
		$classes = array( 'edgtf-item-space' );
		
		if ( isset( $params['featured'] ) && $params['featured'] == 'yes' ) {
			$classes[] = 'edgtf-featured';
		}
		
		return implode( ' ', $classes );
	}
}