<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_package_list_shortcode_helper' ) ) {
	function urbango_listing_package_list_shortcode_helper( $shortcodes_class_name ) {
		$shortcodes = array(
			'UrbanGoListing\CPT\Shortcodes\Package\PackageList'
		);
		
		$shortcodes_class_name = array_merge( $shortcodes_class_name, $shortcodes );
		
		return $shortcodes_class_name;
	}
	
	add_filter( 'urbango_listing_filter_add_vc_shortcode', 'urbango_listing_package_list_shortcode_helper' );
}

if ( ! function_exists( 'urbango_listing_set_package_list_icon_class_name_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom icon class name for package list shortcode to set our icon for Visual Composer shortcodes panel
	 */
	function urbango_listing_set_package_list_icon_class_name_for_vc_shortcodes( $shortcodes_icon_class_array ) {
		$shortcodes_icon_class_array[] = '.icon-wpb-package-list';
		
		return $shortcodes_icon_class_array;
	}
	
	add_filter( 'urbango_listing_filter_add_vc_shortcodes_custom_icon_class', 'urbango_listing_set_package_list_icon_class_name_for_vc_shortcodes' );
}

if ( ! function_exists( 'urbango_listing_package_list_shortcode_item_values' ) ) {
	function urbango_listing_package_list_shortcode_item_values( $package_id ) {
		$values = array();
		
		// Generate Listings included
		$unlimited_packages = get_post_meta( $package_id, 'edgtf_package_unlimited_listings_meta', true );
		if ( $unlimited_packages === 'yes' ) {
			$listings_included = esc_html__( 'Unlimited', 'urbango-listing' );
		} else {
			$listings_included = get_post_meta( $package_id, 'edgtf_package_listings_included_meta', true );
		}
		$values['listings_inluded'] = $listings_included;
		
		// Generate Featured listings included
		$number_of_featured_listings = get_post_meta( $package_id, 'edgtf_package_featured_listings_included_meta', true );
		$values['featured_inluded']  = $number_of_featured_listings;
		
		// Generate duration of package
		$package_duration   = get_post_meta( $package_id, 'edgtf_package_duration_meta', true );
		$package_duration   = ! empty( $package_duration ) ? $package_duration : 12;
		$values['duration'] = $package_duration;
		
		// Generate price of package
		$package_price   = get_post_meta( $package_id, 'edgtf_package_price_meta', true );
		$values['price'] = $package_price;
		
		// Generate currency of package
		$package_currency   = urbango_listing_is_woocommerce_installed() ? get_woocommerce_currency_symbol() : apply_filters( 'urbango_listing_filter_set_default_package_currency', '$' );
		$values['currency'] = $package_currency;
		
		// Generate ads of package
		$package_ads   = get_post_meta( $package_id, 'edgtf_package_allow_listing_ads_meta', true );
		$values['ads'] = $package_ads;
		
		return $values;
	}
}

if ( ! function_exists( 'urbango_listing_package_get_item_icon' ) ) {
	function urbango_listing_package_get_item_icon( $item_value, $item_class ) {
		$icon_class = empty( $item_value ) ? 'icon_close' : 'icon_check';
		$icon_html  = urbango_edge_icon_collections()->renderIcon( $icon_class, 'font_elegant', array( 'icon_attributes' => array( 'class' => 'edgtf-pli-icon ' . esc_attr( $item_class ) ) ) );
		
		return $icon_html;
	}
}
