<?php

namespace UrbanGoListing\CPT\Package;

use UrbanGoListing\PostTypes\PostTypesInterface;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Class PackageRegister
 * @package UrbanGoListing\CPT\Listing
 */
class PackageRegister implements PostTypesInterface {
	
	/**
	 * Singleton variables
	 */
	private $base;
	
	public function __construct() {
		$this->base = 'package';
	}
	
	/**
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}
	
	/**
	 * Registers custom post type and taxonomies
	 */
	public function register() {
		$this->registerPostType();
		$this->registerTaxonomies();
	}
	
	/**
	 * Registers custom post type with WordPress
	 */
	private function registerPostType() {
		$menuPosition = 31;
		$menuIcon     = 'dashicons-media-text';
		
		register_post_type( $this->getBase(),
			array(
				'labels'              => array(
					'name'          => esc_html__( 'UrbanGo Pricing Packages', 'urbango-listing' ),
					'singular_name' => esc_html__( 'Pricing Package', 'urbango-listing' ),
					'add_item'      => esc_html__( 'New Pricing Package', 'urbango-listing' ),
					'add_new_item'  => esc_html__( 'Add New Pricing Package', 'urbango-listing' ),
					'edit_item'     => esc_html__( 'Edit Pricing Package', 'urbango-listing' )
				),
				'public'              => true,
				'has_archive'         => false,
				'rewrite'             => array( 'slug' => $this->getBase() ),
				'menu_position'       => $menuPosition,
				'show_in_menu'        => true,
				'show_ui'             => true,
				'supports'            => array(
					'title',
					'thumbnail'
				),
				'menu_icon'           => $menuIcon,
				'exclude_from_search' => true,
				'show_in_admin_bar'   => false,
				'show_in_nav_menus'   => false,
				'publicly_queryable'  => false,
				'query_var'           => false,
				'capability_type'     => $this->getBase(),
				'map_meta_cap'        => true
			)
		);
	}
	
	/**
	 * Registers custom taxonomies for CPT with WordPress
	 */
	private function registerTaxonomies() {
		$cptTaxonomies = array(
			'category' => array(
				'key'        => 'package-category',
				'name'       => esc_html__( 'Categories', 'urbango-listing' ),
				'label'      => esc_html__( 'Category', 'urbango-listing' ),
				'show_ui'    => null,
				'show_admin' => true
			)
		);
		
		foreach ( $cptTaxonomies as $key => $value ) {
			$labels = array(
				'name'              => $value['name'],
				'singular_name'     => $value['label'],
				'search_items'      => sprintf( esc_html__( 'Search %s', 'urbango-listing' ), $value['name'] ),
				'all_items'         => sprintf( esc_html__( 'All %s', 'urbango-listing' ), $value['name'] ),
				'parent_item'       => sprintf( esc_html__( 'Parent %s', 'urbango-listing' ), $value['label'] ),
				'parent_item_colon' => sprintf( esc_html__( 'Parent %s:', 'urbango-listing' ), $value['label'] ),
				'edit_item'         => sprintf( esc_html__( 'Edit %s', 'urbango-listing' ), $value['label'] ),
				'update_item'       => sprintf( esc_html__( 'Update %s', 'urbango-listing' ), $value['label'] ),
				'add_new_item'      => sprintf( esc_html__( 'Add New %s', 'urbango-listing' ), $value['label'] ),
				'new_item_name'     => sprintf( esc_html__( 'New %s Name', 'urbango-listing' ), $value['label'] ),
				'menu_name'         => $value['name']
			);
			
			register_taxonomy( $value['key'], array( $this->getBase() ), array(
				'hierarchical'       => true,
				'labels'             => $labels,
				'show_ui'            => true,
				'show_in_quick_edit' => $value['show_ui'],
				'meta_box_cb'        => $value['show_ui'],
				'query_var'          => false,
				'show_admin_column'  => $value['show_admin'],
				'rewrite'            => array( 'slug' => $value['key'] )
			) );
		}
	}
}
