<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$packages_params = array(
	'package_name' => array(
		'label' => esc_html__( 'Package', 'urbango-listing' ),
		'type'  => 'simple'
	),
	'expiration_date'          => array(
		'label' => esc_html__( 'Expiration Date', 'urbango-listing' ),
		'type'  => 'date'
	),
	'items_included' => array(
		'label' => esc_html__( 'Items Included', 'urbango-listing' ),
		'type'  => 'simple'
	),
	'items_remaining' => array(
		'label' => esc_html__( 'Items Remaining', 'urbango-listing' ),
		'type'  => 'simple'
	),
	'featured_items_included' => array(
		'label' => esc_html__( 'Featured Items Included', 'urbango-listing' ),
		'type'  => 'simple'
	),
	'featured_items_remaining' => array(
		'label' => esc_html__( 'Featured Items Remaining', 'urbango-listing' ),
		'type'  => 'simple'
	),
	'ads_allowed' => array(
		'label' => esc_html__( 'Ads Allowed', 'urbango-listing' ),
		'type'  => 'simple'
	),
	'status' => array(
		'label' => esc_html__( 'Status', 'urbango-listing' ),
		'type'  => false
	)
);
?>
<div class="edgtf-listing-profile-my-packages">
	<?php if ( ! empty( $my_packages ) ) { ?>
		<div class="edgtf-lp-section-title">
			<h3 class="edgtf-lp-st-title"><?php esc_html_e( 'My Packages', 'urbango-listing' ); ?></h3>
			<p class="edgtf-lp-st-text"><?php esc_html_e( 'Here you will have a practical overview of the pricing packages you have purchased alongside a detailed presentation of what each package offers.', 'urbango-listing' ); ?></p>
		</div>
		<div class="edgtf-lp-packages-items">
			<div class="edgtf-lp-pi-heading">
				<?php foreach ( $packages_params as $param_key => $param_value ) {
					$item_class = 'edgtf-lp-pi-heading-' . str_replace( '_', '-', $param_key );
					?>
					<span class="<?php echo esc_attr( $item_class ); ?>"><?php echo esc_attr( $param_value['label'] ); ?></span>
				<?php } ?>
			</div>
			<div class="edgtf-lp-pi-content">
				<?php foreach ( $my_packages as $package ) {
					$package_info = urbango_listing_get_package_info( $package );
					?>
					<div class="edgtf-lp-pi-content-row">
						<?php foreach ( $packages_params as $param_key => $param_value ) {
							$item_class = 'edgtf-lp-pi-content-' . str_replace( '_', '-', $param_key );
							$item_value = esc_html__( '/', 'urbango-listing' );
							
							if ( ! empty( $package_info[ $param_key ] ) ) {
								if ( $param_value['type'] === 'date' ) {
									$item_value = gmdate( 'd/m/Y', $package_info[ $param_key ] );
								} else {
									$item_value = $package_info[ $param_key ];
								}
							}
							
							if ( ! empty( $param_value['type'] ) ) { ?>
								<div class="<?php echo esc_attr( $item_class ); ?>"><?php echo esc_html( $item_value ); ?></div>
							<?php } else { ?>
								<div class="<?php echo esc_attr( $item_class ); ?>"><?php echo urbango_listing_get_package_status( $package ); ?></div>
							<?php } ?>
						<?php } ?>
					</div>
				<?php } ?>
			</div>
		</div>
		<?php if ( urbango_listing_is_core_plugin_installed() ) {
			echo urbango_edge_get_button_html( array(
				'custom_class' => 'edgtf-membership-buy-package',
				'type'         => 'outline',
				'size'         => 'small',
				'text'         => esc_html__( 'Buy Package', 'urbango-listing' ),
				'link'         => esc_url( $package_url )
			) );
		} ?>
	<?php } else { ?>
		<h3 class="edgtf-lp-not-found"><?php esc_html_e( 'You don\'t have any package.', 'urbango-listing' ); ?></h3>
	<?php } ?>
</div>