<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_include_listing_widgets' ) ) {
	/**
	 * Loads all widgets by going through all folders that are placed directly in widgets folder
	 */
	function urbango_listing_include_listing_widgets() {
		if ( urbango_listing_is_core_plugin_installed() ) {
			foreach ( glob( URBANGO_LISTING_CPT_PATH . '/listing/widgets/*/load.php' ) as $widget_load ) {
				include_once $widget_load;
			}
		}
	}

	add_action( 'after_setup_theme', 'urbango_listing_include_listing_widgets' ); // hook need to be after_setup_theme or some early because of widgets loading
}
